/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.index.IndexDeleteRequest;
import org.elasticsearch.action.delete.index.IndexDeleteResponse;
import org.elasticsearch.action.delete.index.ShardDeleteResponse;
import org.elasticsearch.action.delete.index.TransportIndexDeleteAction;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteAction
extends TransportShardReplicationOperationAction<DeleteRequest, DeleteRequest, DeleteResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final TransportCreateIndexAction createIndexAction;
    private final TransportIndexDeleteAction indexDeleteAction;

    @Inject
    public TransportDeleteAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, TransportCreateIndexAction createIndexAction, TransportIndexDeleteAction indexDeleteAction) {
        super(settings, transportService, clusterService, indicesService, threadPool, shardStateAction);
        this.createIndexAction = createIndexAction;
        this.indexDeleteAction = indexDeleteAction;
        this.autoCreateIndex = new AutoCreateIndex(settings);
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected void doExecute(final DeleteRequest request, final ActionListener<DeleteResponse> listener) {
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), this.clusterService.state())) {
            request.beforeLocalFork();
            this.createIndexAction.execute(new CreateIndexRequest(request.index()).cause("auto(delete api)").masterNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportDeleteAction.this.innerExecute(request, listener);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException) {
                        TransportDeleteAction.this.innerExecute(request, listener);
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(request, listener);
        }
    }

    @Override
    protected boolean resolveRequest(ClusterState state, final DeleteRequest request, final ActionListener<DeleteResponse> listener) {
        MappingMetaData mappingMd;
        request.routing(state.metaData().resolveIndexRouting(request.routing(), request.index()));
        request.index(state.metaData().concreteIndex(request.index()));
        if (state.metaData().hasIndex(request.index()) && (mappingMd = state.metaData().index(request.index()).mappingOrDefault(request.type())) != null && mappingMd.routing().required() && request.routing() == null) {
            if (request.versionType() != VersionType.INTERNAL) {
                throw new ElasticsearchIllegalArgumentException("routing value is required for deleting documents of type [" + request.type() + "] while using version_type [" + (Object)((Object)request.versionType()));
            }
            this.indexDeleteAction.execute(new IndexDeleteRequest(request), new ActionListener<IndexDeleteResponse>(){

                @Override
                public void onResponse(IndexDeleteResponse indexDeleteResponse) {
                    long version = 0L;
                    boolean found = false;
                    for (ShardDeleteResponse deleteResponse : indexDeleteResponse.getResponses()) {
                        if (!deleteResponse.isFound()) continue;
                        version = deleteResponse.getVersion();
                        found = true;
                        break;
                    }
                    listener.onResponse(new DeleteResponse(request.index(), request.type(), request.id(), version, found));
                }

                @Override
                public void onFailure(Throwable e) {
                    listener.onFailure(e);
                }
            });
            return false;
        }
        return true;
    }

    private void innerExecute(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        super.doExecute(request, listener);
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected DeleteRequest newRequestInstance() {
        return new DeleteRequest();
    }

    @Override
    protected DeleteRequest newReplicaRequestInstance() {
        return new DeleteRequest();
    }

    @Override
    protected DeleteResponse newResponseInstance() {
        return new DeleteResponse();
    }

    @Override
    protected String transportAction() {
        return "delete";
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, DeleteRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, DeleteRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<DeleteResponse, DeleteRequest> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.PrimaryOperationRequest shardRequest) {
        DeleteRequest request = (DeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(((DeleteRequest)shardRequest.request).index()).shardSafe(shardRequest.shardId);
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version()).versionType(request.versionType()).origin(Engine.Operation.Origin.PRIMARY);
        indexShard.delete(delete);
        request.versionType(delete.versionType().versionTypeForReplicationAndRecovery());
        request.version(delete.version());
        assert (request.versionType().validateVersion(request.version()));
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh("refresh_flag_delete").force(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DeleteResponse response = new DeleteResponse(request.index(), request.type(), request.id(), delete.version(), delete.found());
        return new TransportShardReplicationOperationAction.PrimaryResponse<DeleteResponse, DeleteRequest>((DeleteRequest)shardRequest.request, response, null);
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ReplicaOperationRequest shardRequest) {
        DeleteRequest request = (DeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(((DeleteRequest)shardRequest.request).index()).shardSafe(shardRequest.shardId);
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version()).versionType(request.versionType()).origin(Engine.Operation.Origin.REPLICA);
        indexShard.delete(delete);
        if (request.refresh()) {
            try {
                indexShard.refresh(new Engine.Refresh("refresh_flag_delete").force(false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, DeleteRequest request) {
        return this.clusterService.operationRouting().deleteShards(this.clusterService.state(), request.index(), request.type(), request.id(), request.routing());
    }
}

