/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.script.SearchScript;

public class StringScriptDataComparator
extends FieldComparator<BytesRef> {
    private BytesRef top;
    private final SearchScript script;
    private BytesRef[] values;
    private BytesRef bottom;
    private final BytesRef spare = new BytesRef();
    private int spareDoc = -1;

    public static IndexFieldData.XFieldComparatorSource comparatorSource(SearchScript script) {
        return new InnerSource(script);
    }

    public StringScriptDataComparator(int numHits, SearchScript script) {
        this.script = script;
        this.values = new BytesRef[numHits];
    }

    public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
        this.script.setNextReader(context);
        this.spareDoc = -1;
        return this;
    }

    public void setScorer(Scorer scorer) {
        this.script.setScorer(scorer);
    }

    public int compare(int slot1, int slot2) {
        BytesRef val1 = this.values[slot1];
        BytesRef val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return val1.compareTo(val2);
    }

    public int compareBottom(int doc) {
        if (this.bottom == null) {
            return -1;
        }
        this.setSpare(doc);
        return this.bottom.compareTo(this.spare);
    }

    public int compareTop(int doc) throws IOException {
        this.script.setNextDocId(doc);
        this.setSpare(doc);
        return this.top.compareTo(this.spare);
    }

    private void setSpare(int doc) {
        if (this.spareDoc == doc) {
            return;
        }
        this.script.setNextDocId(doc);
        this.spare.copyChars((CharSequence)this.script.run().toString());
        this.spareDoc = doc;
    }

    public void copy(int slot, int doc) {
        this.setSpare(doc);
        if (this.values[slot] == null) {
            this.values[slot] = BytesRef.deepCopyOf((BytesRef)this.spare);
        } else {
            this.values[slot].copyBytes(this.spare);
        }
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public void setTopValue(BytesRef top) {
        this.top = top;
    }

    public BytesRef value(int slot) {
        return this.values[slot];
    }

    private static class InnerSource
    extends IndexFieldData.XFieldComparatorSource {
        private final SearchScript script;

        private InnerSource(SearchScript script) {
            this.script = script;
        }

        public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new StringScriptDataComparator(numHits, this.script);
        }

        @Override
        public SortField.Type reducedType() {
            return SortField.Type.STRING;
        }
    }
}

