/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;

public class CountResponse
extends BroadcastOperationResponse {
    private long count;

    CountResponse() {
    }

    CountResponse(long count, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.count = count;
    }

    public long getCount() {
        return this.count;
    }

    public RestStatus status() {
        if (this.getFailedShards() == 0) {
            if (this.getSuccessfulShards() == 0 && this.getTotalShards() > 0) {
                return RestStatus.SERVICE_UNAVAILABLE;
            }
            return RestStatus.OK;
        }
        if (this.getSuccessfulShards() == 0 && this.getTotalShards() > 0) {
            RestStatus status = RestStatus.OK;
            for (ShardOperationFailedException shardFailure : this.getShardFailures()) {
                RestStatus shardStatus = shardFailure.status();
                if (shardStatus.getStatus() < status.getStatus()) continue;
                status = shardStatus;
            }
            return status;
        }
        return RestStatus.OK;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.count = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.count);
    }
}

