/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.IndexShardException;
import org.elasticsearch.rest.RestStatus;

public class DefaultShardOperationFailedException
implements ShardOperationFailedException {
    private String index;
    private int shardId;
    private String reason;
    private RestStatus status;

    private DefaultShardOperationFailedException() {
    }

    public DefaultShardOperationFailedException(IndexShardException e) {
        this.index = e.shardId().index().name();
        this.shardId = e.shardId().id();
        this.reason = ExceptionsHelper.detailedMessage(e);
        this.status = e.status();
    }

    public DefaultShardOperationFailedException(String index, int shardId, Throwable t) {
        this.index = index;
        this.shardId = shardId;
        this.reason = ExceptionsHelper.detailedMessage(t);
        this.status = t != null && t instanceof ElasticsearchException ? ((ElasticsearchException)t).status() : RestStatus.INTERNAL_SERVER_ERROR;
    }

    @Override
    public String index() {
        return this.index;
    }

    @Override
    public int shardId() {
        return this.shardId;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    public static DefaultShardOperationFailedException readShardOperationFailed(StreamInput in) throws IOException {
        DefaultShardOperationFailedException exp = new DefaultShardOperationFailedException();
        exp.readFrom(in);
        return exp;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.index = in.readString();
        }
        this.shardId = in.readVInt();
        this.reason = in.readString();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.index == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.index);
        }
        out.writeVInt(this.shardId);
        out.writeString(this.reason);
        RestStatus.writeTo(out, this.status);
    }

    public String toString() {
        return "[" + this.index + "][" + this.shardId + "] failed, reason [" + this.reason + "]";
    }
}

