/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.ParentChildAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.search.internal.SearchContext;

public class ParentQuery
extends Query {
    private final ParentChildIndexFieldData parentChildIndexFieldData;
    private Query originalParentQuery;
    private final String parentType;
    private final Filter childrenFilter;
    private Query rewrittenParentQuery;
    private IndexReader rewriteIndexReader;

    public ParentQuery(ParentChildIndexFieldData parentChildIndexFieldData, Query parentQuery, String parentType, Filter childrenFilter) {
        this.parentChildIndexFieldData = parentChildIndexFieldData;
        this.originalParentQuery = parentQuery;
        this.parentType = parentType;
        this.childrenFilter = childrenFilter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ParentQuery that = (ParentQuery)((Object)obj);
        if (!this.originalParentQuery.equals((Object)that.originalParentQuery)) {
            return false;
        }
        if (!this.parentType.equals(that.parentType)) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    public int hashCode() {
        int result = this.originalParentQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("ParentQuery[").append(this.parentType).append("](").append(this.originalParentQuery.toString(field)).append(')').append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenParentQuery == null) {
            this.rewriteIndexReader = reader;
            this.rewrittenParentQuery = this.originalParentQuery.rewrite(reader);
        }
        return this;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenParentQuery.extractTerms(terms);
    }

    public Query clone() {
        ParentQuery q = (ParentQuery)super.clone();
        q.originalParentQuery = this.originalParentQuery.clone();
        if (q.rewrittenParentQuery != null) {
            q.rewrittenParentQuery = this.rewrittenParentQuery.clone();
        }
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        block8: {
            block9: {
                searchContext = SearchContext.current();
                collector = new ParentIdAndScoreCollector(searchContext, this.parentChildIndexFieldData, this.parentType);
                releaseCollectorResource = true;
                try {
                    if (this.rewrittenParentQuery == null) {
                        parentQuery = this.rewrittenParentQuery = searcher.rewrite(this.originalParentQuery);
                    } else {
                        if (!ParentQuery.$assertionsDisabled && this.rewriteIndexReader != searcher.getIndexReader()) {
                            throw new AssertionError((Object)("not equal, rewriteIndexReader=" + this.rewriteIndexReader + " searcher.getIndexReader()=" + searcher.getIndexReader()));
                        }
                        parentQuery = this.rewrittenParentQuery;
                    }
                    indexSearcher = new IndexSearcher(searcher.getIndexReader());
                    indexSearcher.setSimilarity(searcher.getSimilarity());
                    indexSearcher.search(parentQuery, (Collector)collector);
                    scores = ParentIdAndScoreCollector.access$000(collector);
                    parentIds = ParentIdAndScoreCollector.access$100(collector);
                    if (parentIds.size() != 0L) break block8;
                    var9_9 = Queries.newMatchNoDocsQuery().createWeight(searcher);
                    if (!releaseCollectorResource) break block9;
                }
                catch (Throwable var11_11) {
                    if (releaseCollectorResource) {
                        Releasables.release(new Releasable[]{ParentIdAndScoreCollector.access$100(collector), ParentIdAndScoreCollector.access$000(collector)});
                    }
                    throw var11_11;
                }
                Releasables.release(new Releasable[]{ParentIdAndScoreCollector.access$100(collector), ParentIdAndScoreCollector.access$000(collector)});
            }
            return var9_9;
        }
        childWeight = new ChildWeight(searchContext, parentQuery.createWeight(searcher), this.childrenFilter, parentIds, scores);
        releaseCollectorResource = false;
        ** if (!releaseCollectorResource) goto lbl33
lbl-1000:
        // 1 sources

        {
            Releasables.release(new Releasable[]{ParentIdAndScoreCollector.access$100(collector), ParentIdAndScoreCollector.access$000(collector)});
        }
        {
        }
lbl33:
        // 2 sources

        searchContext.addReleasable(childWeight);
        return childWeight;
    }

    private static class ChildScorer
    extends Scorer {
        private final BytesRefHash parentIds;
        private final FloatArray scores;
        private final DocIdSetIterator childrenIterator;
        private final BytesValues.WithOrdinals bytesValues;
        private final Ordinals.Docs ordinals;
        private final FixedBitSet seenOrdinals;
        private final LongArray parentIdsIndex;
        private int currentChildDoc = -1;
        private float currentScore;

        ChildScorer(Weight weight, BytesRefHash parentIds, FloatArray scores, DocIdSetIterator childrenIterator, BytesValues.WithOrdinals bytesValues, Ordinals.Docs ordinals, FixedBitSet seenOrdinals, LongArray parentIdsIndex) {
            super(weight);
            this.parentIds = parentIds;
            this.scores = scores;
            this.childrenIterator = childrenIterator;
            this.bytesValues = bytesValues;
            this.ordinals = ordinals;
            this.seenOrdinals = seenOrdinals;
            this.parentIdsIndex = parentIdsIndex;
        }

        public float score() throws IOException {
            return this.currentScore;
        }

        public int freq() throws IOException {
            return 1;
        }

        public int docID() {
            return this.currentChildDoc;
        }

        public int nextDoc() throws IOException {
            long parentIdx;
            while (true) {
                this.currentChildDoc = this.childrenIterator.nextDoc();
                if (this.currentChildDoc == Integer.MAX_VALUE) {
                    return this.currentChildDoc;
                }
                int ord = (int)this.ordinals.getOrd(this.currentChildDoc);
                if ((long)ord == 0L) continue;
                if (!this.seenOrdinals.get(ord)) {
                    this.seenOrdinals.set(ord);
                    parentIdx = this.parentIds.find(this.bytesValues.getValueByOrd(ord), this.bytesValues.currentValueHash());
                    if (parentIdx == -1L) continue;
                    this.currentScore = this.scores.get(parentIdx);
                    this.parentIdsIndex.set(ord, parentIdx);
                    return this.currentChildDoc;
                }
                parentIdx = this.parentIdsIndex.get(ord);
                if (parentIdx != -1L) break;
            }
            this.currentScore = this.scores.get(parentIdx);
            return this.currentChildDoc;
        }

        public int advance(int target) throws IOException {
            this.currentChildDoc = this.childrenIterator.advance(target);
            if (this.currentChildDoc == Integer.MAX_VALUE) {
                return this.currentChildDoc;
            }
            int ord = (int)this.ordinals.getOrd(this.currentChildDoc);
            if ((long)ord == 0L) {
                return this.nextDoc();
            }
            if (!this.seenOrdinals.get(ord)) {
                this.seenOrdinals.set(ord);
                long parentIdx = this.parentIds.find(this.bytesValues.getValueByOrd(ord), this.bytesValues.currentValueHash());
                if (parentIdx != -1L) {
                    this.currentScore = this.scores.get(parentIdx);
                    this.parentIdsIndex.set(ord, parentIdx);
                    return this.currentChildDoc;
                }
                return this.nextDoc();
            }
            long parentIdx = this.parentIdsIndex.get(ord);
            if (parentIdx != -1L) {
                this.currentScore = this.scores.get(parentIdx);
                return this.currentChildDoc;
            }
            return this.nextDoc();
        }

        public long cost() {
            return this.childrenIterator.cost();
        }
    }

    private class ChildWeight
    extends Weight
    implements Releasable {
        private final SearchContext searchContext;
        private final Weight parentWeight;
        private final Filter childrenFilter;
        private final BytesRefHash parentIds;
        private final FloatArray scores;
        private FixedBitSet seenOrdinalsCache;
        private LongArray parentIdsIndexCache;

        private ChildWeight(SearchContext searchContext, Weight parentWeight, Filter childrenFilter, BytesRefHash parentIds, FloatArray scores) {
            this.searchContext = searchContext;
            this.parentWeight = parentWeight;
            this.childrenFilter = new ApplyAcceptedDocsFilter(childrenFilter);
            this.parentIds = parentIds;
            this.scores = scores;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ParentQuery.this.getBoost(), "not implemented yet...");
        }

        public Query getQuery() {
            return ParentQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.parentWeight.getValueForNormalization();
            return sum *= ParentQuery.this.getBoost() * ParentQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            DocIdSet childrenDocSet = this.childrenFilter.getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(childrenDocSet)) {
                return null;
            }
            BytesValues.WithOrdinals bytesValues = ((ParentChildAtomicFieldData)ParentQuery.this.parentChildIndexFieldData.load(context)).getBytesValues(ParentQuery.this.parentType);
            if (bytesValues == null) {
                return null;
            }
            Ordinals.Docs ordinals = bytesValues.ordinals();
            int maxOrd = (int)ordinals.getMaxOrd();
            BigArrays bigArrays = this.searchContext.bigArrays();
            if (this.parentIdsIndexCache == null) {
                this.parentIdsIndexCache = bigArrays.newLongArray(BigArrays.overSize(maxOrd), false);
            } else if (this.parentIdsIndexCache.size() < (long)maxOrd) {
                this.parentIdsIndexCache = bigArrays.grow(this.parentIdsIndexCache, (long)maxOrd);
            }
            this.parentIdsIndexCache.fill(0L, maxOrd, -1L);
            if (this.seenOrdinalsCache == null || this.seenOrdinalsCache.length() < maxOrd) {
                this.seenOrdinalsCache = new FixedBitSet(maxOrd);
            } else {
                this.seenOrdinalsCache.clear(0, maxOrd);
            }
            return new ChildScorer(this, this.parentIds, this.scores, childrenDocSet.iterator(), bytesValues, ordinals, this.seenOrdinalsCache, this.parentIdsIndexCache);
        }

        @Override
        public boolean release() throws ElasticsearchException {
            Releasables.release(this.parentIds, this.scores, this.parentIdsIndexCache);
            return true;
        }
    }

    private static class ParentIdAndScoreCollector
    extends NoopCollector {
        private final BytesRefHash parentIds;
        private FloatArray scores;
        private final ParentChildIndexFieldData indexFieldData;
        private final String parentType;
        private final BigArrays bigArrays;
        private Scorer scorer;
        private BytesValues values;

        ParentIdAndScoreCollector(SearchContext searchContext, ParentChildIndexFieldData indexFieldData, String parentType) {
            this.bigArrays = searchContext.bigArrays();
            this.parentIds = new BytesRefHash(512L, this.bigArrays);
            this.scores = this.bigArrays.newFloatArray(512L, false);
            this.indexFieldData = indexFieldData;
            this.parentType = parentType;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.values != null) {
                this.values.setDocument(doc);
                long index = this.parentIds.add(this.values.nextValue(), this.values.currentValueHash());
                if (index >= 0L) {
                    this.scores = this.bigArrays.grow(this.scores, index + 1L);
                    this.scores.set(index, this.scorer.score());
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((ParentChildAtomicFieldData)this.indexFieldData.load(context)).getBytesValues(this.parentType);
        }

        static /* synthetic */ FloatArray access$000(ParentIdAndScoreCollector x0) {
            return x0.scores;
        }

        static /* synthetic */ BytesRefHash access$100(ParentIdAndScoreCollector x0) {
            return x0.parentIds;
        }
    }
}

