/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesEstimator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;

public class PercentilesAggregator
extends MetricsAggregator.MultiValue {
    private final NumericValuesSource valuesSource;
    private DoubleValues values;
    private final PercentilesEstimator estimator;
    private final boolean keyed;

    public PercentilesAggregator(String name, long estimatedBucketsCount, NumericValuesSource valuesSource, AggregationContext context, Aggregator parent, PercentilesEstimator estimator, boolean keyed) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        this.keyed = keyed;
        this.estimator = estimator;
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.doubleValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        int valueCount = this.values.setDocument(doc);
        for (int i = 0; i < valueCount; ++i) {
            this.estimator.offer(this.values.nextValue(), owningBucketOrdinal);
        }
    }

    @Override
    public boolean hasMetric(String name) {
        return PercentilesEstimator.indexOfPercent(this.estimator.percents, Double.parseDouble(name)) >= 0;
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        return this.estimator.result(owningBucketOrd).estimate(Double.parseDouble(name));
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalPercentiles(this.name, this.estimator.result(owningBucketOrdinal), this.keyed);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalPercentiles(this.name, this.estimator.emptyResult(), this.keyed);
    }

    @Override
    protected void doRelease() {
        this.estimator.release();
    }

    public static class Factory
    extends ValueSourceAggregatorFactory.LeafOnly<NumericValuesSource> {
        private final PercentilesEstimator.Factory estimatorFactory;
        private final double[] percents;
        private final boolean keyed;

        public Factory(String name, ValuesSourceConfig<NumericValuesSource> valuesSourceConfig, double[] percents, PercentilesEstimator.Factory estimatorFactory, boolean keyed) {
            super(name, InternalPercentiles.TYPE.name(), valuesSourceConfig);
            this.estimatorFactory = estimatorFactory;
            this.percents = percents;
            this.keyed = keyed;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new PercentilesAggregator(this.name, 0L, null, aggregationContext, parent, (PercentilesEstimator)this.estimatorFactory.create(this.percents, 0L, aggregationContext), this.keyed);
        }

        @Override
        protected Aggregator create(NumericValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            Object estimator = this.estimatorFactory.create(this.percents, expectedBucketsCount, aggregationContext);
            return new PercentilesAggregator(this.name, expectedBucketsCount, valuesSource, aggregationContext, parent, (PercentilesEstimator)estimator, this.keyed);
        }
    }
}

