/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.es.ext.pp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.search.aggregations.Aggregation;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;
import org.nuxeo.elasticsearch.aggregate.AggregateFactory;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.provider.ElasticSearchNxqlPageProvider;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.labs.es.ext.pp.ExtendedNxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class ExtendedElasticSearchNxqlPageProvider
extends ElasticSearchNxqlPageProvider {
    public List<DocumentModel> getCurrentPage() {
        long t0 = System.currentTimeMillis();
        if (this.currentPageDocuments != null) {
            return this.currentPageDocuments;
        }
        this.error = null;
        this.errorMessage = null;
        log.debug("Perform query for provider '{}': with pageSize={}, offset={}", new Supplier[]{() -> ((ExtendedElasticSearchNxqlPageProvider)this).getName(), () -> ((ExtendedElasticSearchNxqlPageProvider)this).getMinMaxPageSize(), () -> ((ExtendedElasticSearchNxqlPageProvider)this).getCurrentPageOffset()});
        this.currentPageDocuments = new ArrayList();
        CoreSession coreSession = this.getCoreSession();
        if (this.query == null) {
            this.buildQuery(coreSession);
        }
        if (this.query == null) {
            throw new NuxeoException(String.format("Cannot perform null query: check provider '%s'", this.getName()));
        }
        ElasticSearchService ess = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
        try {
            NxQueryBuilder nxQuery = this.getQueryBuilder(coreSession).nxql(this.query).offset((int)this.getCurrentPageOffset()).limit(this.getLimit()).addAggregates(this.buildAggregates());
            if (this.searchOnAllRepositories()) {
                nxQuery.searchOnAllRepositories();
            }
            nxQuery.useUnrestrictedSession(this.useUnrestrictedSession());
            List highlightFields = this.getHighlights();
            if (highlightFields != null && !highlightFields.isEmpty()) {
                nxQuery.highlight(highlightFields);
            }
            EsResult ret = ess.queryAndAggregate(nxQuery);
            DocumentModelList dmList = ret.getDocuments();
            this.currentAggregates = new HashMap(ret.getAggregates().size());
            for (Aggregate agg : ret.getAggregates()) {
                this.currentAggregates.put(agg.getId(), agg);
            }
            this.setResultsCount(dmList.totalSize());
            this.currentPageDocuments = dmList;
        }
        catch (QueryParseException e) {
            this.error = e;
            this.errorMessage = e.getMessage();
            log.warn(e.getMessage(), (Throwable)e);
        }
        this.fireSearchEvent(this.getCoreSession().getPrincipal(), this.query, this.currentPageDocuments, System.currentTimeMillis() - t0);
        return this.currentPageDocuments;
    }

    private List<AggregateEsBase<? extends Aggregation, ? extends Bucket>> buildAggregates() {
        ArrayList<AggregateEsBase<? extends Aggregation, ? extends Bucket>> ret = new ArrayList<AggregateEsBase<? extends Aggregation, ? extends Bucket>>(this.getAggregateDefinitions().size());
        boolean skip = this.isSkipAggregates();
        for (AggregateDefinition def : this.getAggregateDefinitions()) {
            AggregateEsBase agg = AggregateFactory.create((AggregateDefinition)def, (DocumentModel)this.getSearchDocumentModel());
            if (skip && agg.getSelection().isEmpty()) continue;
            ret.add((AggregateEsBase<? extends Aggregation, ? extends Bucket>)AggregateFactory.create((AggregateDefinition)def, (DocumentModel)this.getSearchDocumentModel()));
        }
        return ret;
    }

    public NxQueryBuilder getQueryBuilder(CoreSession session) {
        this.getParameters();
        return new ExtendedNxQueryBuilder(this.getCoreSession());
    }
}

