/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.faceted.search.jsf;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.json.JSONException;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewHeader;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.faceted.search.api.service.Configuration;
import org.nuxeo.ecm.platform.faceted.search.api.service.FacetedSearchService;
import org.nuxeo.ecm.platform.faceted.search.api.util.JSONMetadataExporter;
import org.nuxeo.ecm.platform.faceted.search.api.util.JSONMetadataHelper;
import org.nuxeo.ecm.platform.forms.layout.io.Base64;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="facetedSearchActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class FacetedSearchActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DUBLINCORE_SCHEMA = "dublincore";
    public static final String NONE_VALUE = "none";
    public static final String NONE_LABEL = "label.none";
    public static final String USER_SAVED_SEARCHES_LABEL = "label.user.saved.searches";
    public static final String ALL_SAVED_SEARCHES_LABEL = "label.all.saved.searches";
    public static final String FLAGGED_SAVED_SEARCHES_LABEL = "label.flagged.saved.searches";
    public static final String SEARCH_SAVED_LABEL = "label.search.saved";
    public static final String FACETED_SEARCH_CODEC = "facetedSearch";
    public static final String CONTENT_VIEW_NAME_PARAMETER = "contentViewName";
    public static final String FILTER_VALUES_PARAMETER = "values";
    public static final String ENCODED_VALUES_ENCODING = "UTF-8";
    @In(create=true)
    protected ContentViewActions contentViewActions;
    @In(create=true)
    protected transient ContentViewService contentViewService;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected List<String> contentViewNames;
    protected Set<ContentViewHeader> contentViewHeaders;
    protected String currentContentViewName;
    protected String currentSelectedSavedSearchId;
    protected String savedSearchTitle;

    @Factory(value="facetedSearchCurrentContentViewName", scope=ScopeType.EVENT)
    public String getCurrentContentViewName() throws ClientException {
        List<String> contentViewNames;
        if (this.currentContentViewName == null && !(contentViewNames = this.getContentViewNames()).isEmpty()) {
            this.currentSelectedSavedSearchId = this.currentContentViewName = contentViewNames.get(0);
        }
        return this.currentContentViewName;
    }

    public void setCurrentContentViewName(String facetedSearchCurrentContentViewName) {
        this.currentContentViewName = facetedSearchCurrentContentViewName;
    }

    public List<String> getContentViewNames() throws ClientException {
        if (this.contentViewNames == null) {
            this.contentViewNames = new ArrayList<String>(((FacetedSearchService)Framework.getLocalService(FacetedSearchService.class)).getContentViewNames(this.navigationContext.getCurrentDocument()));
        }
        return this.contentViewNames;
    }

    public Set<ContentViewHeader> getContentViewHeaders() throws ClientException {
        if (this.contentViewHeaders == null) {
            this.contentViewHeaders = new HashSet<ContentViewHeader>();
            for (String name : this.getContentViewNames()) {
                ContentViewHeader header = this.contentViewService.getContentViewHeader(name);
                if (header == null) continue;
                this.contentViewHeaders.add(header);
            }
        }
        return this.contentViewHeaders;
    }

    public void clearSearch() {
        this.contentViewActions.reset(this.currentContentViewName);
        this.currentSelectedSavedSearchId = null;
    }

    public List<DocumentModel> getCurrentUserSavedSearches() throws ClientException {
        return ((FacetedSearchService)Framework.getLocalService(FacetedSearchService.class)).getCurrentUserSavedSearches(this.documentManager);
    }

    public List<DocumentModel> getOtherUsersSavedSearches() throws ClientException {
        return ((FacetedSearchService)Framework.getLocalService(FacetedSearchService.class)).getOtherUsersSavedSearches(this.documentManager);
    }

    @Factory(value="allSavedSearchesSelectItems", scope=ScopeType.EVENT)
    public List<SelectItem> getAllSavedSearchesSelectItems() throws ClientException {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        items.add(new SelectItem((Object)NONE_VALUE, (String)this.resourcesAccessor.getMessages().get(NONE_LABEL)));
        SelectItemGroup userGroup = new SelectItemGroup((String)this.resourcesAccessor.getMessages().get(USER_SAVED_SEARCHES_LABEL));
        List<DocumentModel> userSavedSearches = this.getCurrentUserSavedSearches();
        List<SelectItem> userSavedSearchesItems = this.convertToSelectItems(userSavedSearches);
        userGroup.setSelectItems(userSavedSearchesItems.toArray(new SelectItem[userSavedSearchesItems.size()]));
        items.add((SelectItem)userGroup);
        List<DocumentModel> otherUsersSavedFacetedSearches = this.getOtherUsersSavedSearches();
        List<SelectItem> otherUsersSavedSearchesItems = this.convertToSelectItems(otherUsersSavedFacetedSearches);
        SelectItemGroup allGroup = new SelectItemGroup((String)this.resourcesAccessor.getMessages().get(ALL_SAVED_SEARCHES_LABEL));
        allGroup.setSelectItems(otherUsersSavedSearchesItems.toArray(new SelectItem[otherUsersSavedSearchesItems.size()]));
        items.add((SelectItem)allGroup);
        SelectItemGroup flaggedGroup = new SelectItemGroup((String)this.resourcesAccessor.getMessages().get(FLAGGED_SAVED_SEARCHES_LABEL));
        Set<ContentViewHeader> flaggedSavedSearches = this.getContentViewHeaders();
        List<SelectItem> flaggedSavedSearchesItems = this.convertCVToSelectItems(flaggedSavedSearches);
        flaggedGroup.setSelectItems(flaggedSavedSearchesItems.toArray(new SelectItem[flaggedSavedSearchesItems.size()]));
        items.add((SelectItem)flaggedGroup);
        return items;
    }

    protected List<SelectItem> convertToSelectItems(List<DocumentModel> docs) throws ClientException {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (DocumentModel doc : docs) {
            items.add(new SelectItem((Object)doc.getId(), doc.getTitle(), ""));
        }
        return items;
    }

    protected List<SelectItem> convertCVToSelectItems(Set<ContentViewHeader> contentViewHeaders) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (ContentViewHeader contentViewHeader : contentViewHeaders) {
            items.add(new SelectItem((Object)contentViewHeader.getName(), (String)this.resourcesAccessor.getMessages().get(contentViewHeader.getTitle()), ""));
        }
        return items;
    }

    public void setCurrentSelectedSavedSearchId(String savedSearchId) throws ClientException {
        this.currentSelectedSavedSearchId = savedSearchId;
    }

    public String getCurrentSelectedSavedSearchId() {
        return this.currentSelectedSavedSearchId;
    }

    public String loadSelectedSavedSearch(String jsfView) throws ClientException {
        this.loadSelectedSavedSearch();
        return jsfView;
    }

    public void loadSelectedSavedSearch() throws ClientException {
        if (this.currentSelectedSavedSearchId == null || this.currentSelectedSavedSearchId.isEmpty() || NONE_VALUE.equals(this.currentSelectedSavedSearchId)) {
            this.contentViewActions.reset(this.currentContentViewName);
        } else {
            this.loadSavedSearch(this.currentSelectedSavedSearchId);
        }
    }

    public void loadSavedSearch(String savedSearchId) throws ClientException {
        if (this.contentViewNames.contains(savedSearchId)) {
            this.contentViewActions.reset(this.currentContentViewName);
            this.currentContentViewName = savedSearchId;
        } else {
            DocumentModel savedSearch = this.documentManager.getDocument((DocumentRef)new IdRef(savedSearchId));
            String contentViewName = (String)((Object)savedSearch.getPropertyValue("fs:content_view_name"));
            this.loadSavedSearch(contentViewName, savedSearch);
        }
    }

    public void loadSavedSearch(String contentViewName, DocumentModel searchDocument) throws ClientException {
        DocumentModel newSearchDocument = this.createDocumentModelFrom(searchDocument);
        ContentView contentView = this.contentViewActions.getContentView(contentViewName, newSearchDocument);
        if (contentView != null) {
            this.currentContentViewName = contentViewName;
        }
    }

    public String getSavedSearchTitle() {
        return this.savedSearchTitle;
    }

    public void setSavedSearchTitle(String savedSearchTitle) {
        this.savedSearchTitle = savedSearchTitle;
    }

    public void saveSearch() throws ClientException {
        ContentView contentView = this.contentViewActions.getContentView(this.currentContentViewName);
        if (contentView != null) {
            DocumentModel savedSearch = ((FacetedSearchService)Framework.getLocalService(FacetedSearchService.class)).saveSearch(this.documentManager, contentView, this.savedSearchTitle);
            this.currentSelectedSavedSearchId = savedSearch.getId();
            this.savedSearchTitle = null;
            DocumentModel searchDocument = this.createDocumentModelFrom(savedSearch);
            contentView.setSearchDocumentModel(searchDocument);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{savedSearch});
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get(SEARCH_SAVED_LABEL), new Object[0]);
        }
    }

    protected DocumentModel createDocumentModelFrom(DocumentModel sourceDoc) throws ClientException {
        DocumentModel doc = this.documentManager.createDocumentModel(sourceDoc.getType());
        for (String schema : sourceDoc.getDocumentType().getSchemaNames()) {
            if (DUBLINCORE_SCHEMA.equals(schema)) continue;
            DataModel dm = sourceDoc.getDataModel(schema);
            SchemaManager mgr = (SchemaManager)Framework.getLocalService(SchemaManager.class);
            DataModel newDM = DocumentModelImpl.cloneDataModel((Schema)mgr.getSchema(dm.getSchema()), (DataModel)dm);
            doc.getDataModel(schema).setMap(newDM.getMap());
        }
        return doc;
    }

    protected String encodeValues(String values) throws UnsupportedEncodingException {
        String encodedValues = Base64.encodeBytes((byte[])values.getBytes(), (int)10);
        encodedValues = URLEncoder.encode(encodedValues, ENCODED_VALUES_ENCODING);
        return encodedValues;
    }

    protected String decodeValues(String values) throws UnsupportedEncodingException {
        String decodedValues = URLDecoder.decode(values, ENCODED_VALUES_ENCODING);
        decodedValues = new String(Base64.decode((String)decodedValues));
        return decodedValues;
    }

    public void setFilterValues(String filterValues) throws ClientException, JSONException, UnsupportedEncodingException {
        ContentView contentView = this.contentViewActions.getContentView(this.currentContentViewName);
        DocumentModel searchDocumentModel = contentView.getSearchDocumentModel();
        String decodedValues = this.decodeValues(filterValues);
        searchDocumentModel = JSONMetadataHelper.setPropertiesFromJson((DocumentModel)searchDocumentModel, (String)decodedValues);
        contentView.setSearchDocumentModel(searchDocumentModel);
    }

    public String getPermanentLinkUrl() throws ClientException, UnsupportedEncodingException {
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)new DocumentLocationImpl(this.documentManager.getRepositoryName(), null));
        docView.addParameter(CONTENT_VIEW_NAME_PARAMETER, this.currentContentViewName);
        ContentView contentView = this.contentViewActions.getContentView(this.currentContentViewName);
        DocumentModel doc = contentView.getSearchDocumentModel();
        String values = this.getEncodedValuesFrom(doc);
        docView.addParameter(FILTER_VALUES_PARAMETER, values);
        DocumentViewCodecManager documentViewCodecManager = this.getDocumentViewCodecService();
        return documentViewCodecManager.getUrlFromDocumentView(FACETED_SEARCH_CODEC, (DocumentView)docView, true, BaseURL.getBaseURL());
    }

    protected DocumentViewCodecManager getDocumentViewCodecService() throws ClientException {
        try {
            return (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        }
        catch (Exception e) {
            String errMsg = "Could not retrieve the document view service. " + e.getMessage();
            throw new ClientException(errMsg, (Throwable)e);
        }
    }

    protected String getEncodedValuesFrom(DocumentModel doc) throws ClientException, UnsupportedEncodingException {
        JSONMetadataExporter exporter = new JSONMetadataExporter();
        String values = exporter.run(doc).toString();
        return this.encodeValues(values);
    }

    @Observer(value={"localConfigurationChanged"})
    public void invalidateContentViewsName() {
        this.clearSearch();
        this.contentViewNames = null;
        this.contentViewHeaders = null;
        this.currentContentViewName = null;
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"})
    public void invalidateContentViewsNameIfChanged() throws ClientException {
        ArrayList temp = new ArrayList(((FacetedSearchService)Framework.getLocalService(FacetedSearchService.class)).getContentViewNames(this.navigationContext.getCurrentDocument()));
        if (temp != null) {
            String s;
            if (!temp.equals(this.contentViewNames)) {
                this.invalidateContentViewsName();
            }
            if (!temp.isEmpty() && (s = (String)temp.get(0)) != null && !s.equals(this.currentContentViewName)) {
                this.invalidateContentViewsName();
            }
        }
    }

    public String getRootSavedSearchesTitle() {
        FacetedSearchService facetedSearchService = (FacetedSearchService)Framework.getLocalService(FacetedSearchService.class);
        Configuration configuration = facetedSearchService.getConfiguration();
        return configuration != null ? configuration.getRootSavedSearchesTitle() : null;
    }

    public boolean haveOldSavedSearches() throws ClientException {
        return !this.getOldSavedSearches().isEmpty();
    }

    protected List<DocumentModel> getOldSavedSearches() throws ClientException {
        UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        FacetedSearchService facetedSearchService = (FacetedSearchService)Framework.getLocalService(FacetedSearchService.class);
        DocumentModel uws = userWorkspaceService.getCurrentUserPersonalWorkspace(this.documentManager, null);
        Configuration configuration = facetedSearchService.getConfiguration();
        String rootSavedSearchesTitle = configuration.getRootSavedSearchesTitle();
        PathSegmentService pathService = (PathSegmentService)Framework.getLocalService(PathSegmentService.class);
        DocumentModel rootSavedSearches = this.documentManager.createDocumentModel(uws.getPathAsString(), rootSavedSearchesTitle, "FacetedSavedSearchesFolder");
        rootSavedSearches.setPathInfo(uws.getPathAsString(), pathService.generatePathSegment(rootSavedSearches));
        Path path = new Path(uws.getPathAsString()).append(pathService.generatePathSegment(rootSavedSearches));
        PathRef rootPathRef = new PathRef(path.toString());
        if (this.documentManager.exists((DocumentRef)rootPathRef)) {
            DocumentModel rootDoc = this.documentManager.getDocument((DocumentRef)rootPathRef);
            String query = String.format("SELECT * FROM Document WHERE ecm:mixinType = 'FacetedSearch' AND ecm:parentId = '%s'", rootDoc.getId());
            return this.documentManager.query(query);
        }
        return Collections.emptyList();
    }

    public void migrateOldSavedSearches() throws ClientException {
        UserWorkspaceService userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        DocumentModel uws = userWorkspaceService.getCurrentUserPersonalWorkspace(this.documentManager, null);
        List<DocumentModel> docs = this.getOldSavedSearches();
        if (!docs.isEmpty()) {
            this.documentManager.move(this.convertToDocumentRefs(docs), uws.getRef());
            this.facesMessages.addFromResourceBundle(StatusMessage.Severity.INFO, "label.faceted.saved.searches.migrated", new Object[]{docs.size()});
            this.contentViewActions.refreshOnSeamEvent("savedSearchesMigrated");
        }
    }

    protected List<DocumentRef> convertToDocumentRefs(List<DocumentModel> docs) {
        ArrayList<DocumentRef> refs = new ArrayList<DocumentRef>();
        for (DocumentModel doc : docs) {
            refs.add(doc.getRef());
        }
        return refs;
    }
}

