/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class HttpServletRequestWrapper
extends javax.servlet.http.HttpServletRequestWrapper {
    protected final Map<String, String> headers = new HashMap<String, String>();

    public HttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String headerName = String.valueOf(e.nextElement());
            if (!StringUtils.isNotEmpty((String)headerName)) continue;
            String value = request.getHeader(headerName);
            this.headers.put(headerName.toLowerCase(), value);
        }
    }

    public String getHeader(String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            return this.headers.get(name.toLowerCase());
        }
        return null;
    }

    public void setHeader(String name, String value) {
        if (StringUtils.isNotEmpty((String)name)) {
            this.headers.put(name.toLowerCase(), value);
        }
    }

    public Enumeration<String> getHeaderNames() {
        return new SetEnumeration(this.headers.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        HashSet<String> set = new HashSet<String>();
        String value = this.headers.get(name);
        if (StringUtils.isNotEmpty((String)value)) {
            set.add(value);
        }
        return new SetEnumeration(set);
    }

    class SetEnumeration
    implements Enumeration<String> {
        private final Iterator<String> iterator;

        public SetEnumeration(Set<String> set) {
            this.iterator = new ArrayList<String>(set).iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.iterator.next();
        }
    }
}

