/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.faceted.search.jsf.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.faceted.search.api.service.Configuration;
import org.nuxeo.ecm.platform.faceted.search.api.service.FacetedSearchService;
import org.nuxeo.ecm.platform.faceted.search.jsf.localconfiguration.FacetedSearchConfiguration;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class FacetedSearchServiceImpl
extends DefaultComponent
implements FacetedSearchService {
    private static Log log = LogFactory.getLog(FacetedSearchServiceImpl.class);
    public static final String CONFIGURATION_EP = "configuration";
    protected Configuration configuration;
    protected ContentViewService contentViewService;
    protected PageProviderService pageProviderService;
    protected UserWorkspaceService userWorkspaceService;
    protected FacetedSearchConfiguration facetedSearchConfiguration;

    public Set<String> getContentViewNames() throws ClientException {
        return this.getContentViewNames(null);
    }

    public Set<String> getContentViewNames(DocumentModel currentDoc) throws ClientException {
        ContentViewService contentViewService = this.getContentViewService();
        return this.doFilterNames(contentViewService.getContentViewNames("FACETED_SEARCH"), currentDoc);
    }

    protected Set<String> doFilterNames(Set<String> contentViewNames, DocumentModel currentDoc) {
        FacetedSearchConfiguration fsConf = this.getFacetedConfiguration(currentDoc);
        return fsConf == null ? contentViewNames : fsConf.filterAllowedContentViewNames(contentViewNames);
    }

    protected FacetedSearchConfiguration getFacetedConfiguration(DocumentModel currentDoc) {
        LocalConfigurationService localConfigurationService = null;
        try {
            localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
        }
        catch (Exception e) {
            String errMsg = "Error connecting to LocalConfigurationService. " + e.getMessage();
            log.error((Object)errMsg, (Throwable)e);
        }
        if (localConfigurationService == null) {
            log.warn((Object)"LocalConfigurationService service not bound");
            return null;
        }
        return (FacetedSearchConfiguration)localConfigurationService.getConfiguration(FacetedSearchConfiguration.class, "FacetedSearchLocalConfiguration", currentDoc);
    }

    protected ContentViewService getContentViewService() throws ClientException {
        if (this.contentViewService == null) {
            try {
                this.contentViewService = (ContentViewService)Framework.getService(ContentViewService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to ContentViewService. " + e.getMessage();
                throw new ClientException(errMsg, (Throwable)e);
            }
            if (this.contentViewService == null) {
                throw new ClientException("ContentViewService service not bound");
            }
        }
        return this.contentViewService;
    }

    protected PageProviderService getPageProviderService() throws ClientException {
        if (this.pageProviderService == null) {
            try {
                this.pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to PageProviderService. " + e.getMessage();
                throw new ClientException(errMsg, (Throwable)e);
            }
            if (this.pageProviderService == null) {
                throw new ClientException("PageProviderService service not bound");
            }
        }
        return this.pageProviderService;
    }

    protected UserWorkspaceService getUserWorkspaceService() throws ClientException {
        if (this.userWorkspaceService == null) {
            try {
                this.userWorkspaceService = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to UserWorkspaceService. " + e.getMessage();
                throw new ClientException(errMsg, (Throwable)e);
            }
            if (this.userWorkspaceService == null) {
                throw new ClientException("UserWorkspaceService service not bound");
            }
        }
        return this.userWorkspaceService;
    }

    public DocumentModel saveSearch(CoreSession session, ContentView facetedSearchContentView, String title) throws ClientException {
        DocumentModel uws = this.getCurrentUserPersonalWorkspace(session);
        DocumentModel searchDoc = facetedSearchContentView.getSearchDocumentModel();
        searchDoc.setPropertyValue("fs:content_view_name", (Serializable)((Object)facetedSearchContentView.getName()));
        searchDoc.setPropertyValue("dc:title", (Serializable)((Object)title));
        PathSegmentService pathService = (PathSegmentService)Framework.getLocalService(PathSegmentService.class);
        searchDoc.setPathInfo(uws.getPathAsString(), pathService.generatePathSegment(searchDoc));
        searchDoc = session.createDocument(searchDoc);
        session.save();
        return searchDoc;
    }

    public List<DocumentModel> getCurrentUserSavedSearches(CoreSession session) throws ClientException {
        return this.getDocuments("USER_SAVED_SEARCHES", session, session.getPrincipal().getName());
    }

    protected DocumentModel getCurrentUserPersonalWorkspace(CoreSession session) throws ClientException {
        UserWorkspaceService userWorkspaceService = this.getUserWorkspaceService();
        return userWorkspaceService.getCurrentUserPersonalWorkspace(session, null);
    }

    protected List<DocumentModel> getDocuments(String pageProviderName, CoreSession session, Object ... parameters) throws ClientException {
        PageProviderService pageProviderService = this.getPageProviderService();
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("coreSession", (Serializable)session);
        return pageProviderService.getPageProvider(pageProviderName, null, null, null, properties, parameters).getCurrentPage();
    }

    public List<DocumentModel> getOtherUsersSavedSearches(CoreSession session) throws ClientException {
        return this.getDocuments("OTHER_USERS_SAVED_SEARCHES", session, session.getPrincipal().getName());
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_EP.equals(extensionPoint)) {
            Configuration desc = (Configuration)contribution;
            if (this.configuration != null) {
                desc = this.mergeConfigurationDescriptor(this.configuration, desc);
            }
            this.configuration = desc;
        }
    }

    protected Configuration mergeConfigurationDescriptor(Configuration oldDesc, Configuration newDesc) {
        if (newDesc.getRootSavedSearchesTitle() != null) {
            oldDesc.setRootSavedSearchesTitle(newDesc.getRootSavedSearchesTitle());
        }
        return oldDesc;
    }
}

