/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.filemanager.automation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import nuxeo.filemanager.automation.FileImporterAutomationDescriptor;
import nuxeo.filemanager.automation.FileImporterAutomationService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class FileImporterAutomationServiceImpl
extends DefaultComponent
implements FileImporterAutomationService {
    private static final Log log = LogFactory.getLog(FileImporterAutomationServiceImpl.class);
    public static final String EXT_POINT = "configuration";
    protected FileImporterAutomationDescriptor descriptor;
    boolean logNoConfigDone = false;
    boolean logNoFileManagerCBChainDone = false;
    boolean logNoFolderManagerCBChainDone = false;

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void applicationStarted(ComponentContext context) {
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EXT_POINT.equals(extensionPoint)) {
            this.descriptor = (FileImporterAutomationDescriptor)contribution;
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    protected boolean hasConfiguration() {
        if (this.descriptor == null) {
            if (!this.logNoConfigDone) {
                log.warn((Object)"No configuration contributed => not doing anything, letting Nuxeo decides");
                this.logNoConfigDone = true;
            }
            return false;
        }
        return true;
    }

    protected boolean hasAFileImporterChain() {
        if (!this.hasConfiguration()) {
            return false;
        }
        String chainId = this.descriptor.getChainId();
        if (StringUtils.isBlank((CharSequence)chainId)) {
            if (!this.logNoFileManagerCBChainDone) {
                log.warn((Object)"No chain ID provided for the File Importer => not doing anything when importing files (Nuxeo will call the next file importer plugin)");
                this.logNoFileManagerCBChainDone = true;
            }
            return false;
        }
        return true;
    }

    protected boolean hasAFolderImporterChain() {
        if (!this.hasConfiguration()) {
            return false;
        }
        String folderChainId = this.descriptor.getFolderImporterChain();
        if (StringUtils.isBlank((CharSequence)folderChainId)) {
            if (!this.logNoFolderManagerCBChainDone) {
                log.warn((Object)"No chain ID provided for Folder Importer => default behavior will apply.");
                this.logNoFolderManagerCBChainDone = true;
            }
            return false;
        }
        return true;
    }

    @Override
    public DocumentModel createOrUpdate(FileImporterContext context) throws NuxeoException {
        if (!this.hasAFileImporterChain()) {
            return null;
        }
        String chainId = this.descriptor.getChainId();
        DocumentModel doc = null;
        PathRef parentRef = new PathRef(context.getParentPath());
        DocumentModel parentDoc = context.getSession().getDocument((DocumentRef)parentRef);
        Blob blob = context.getBlob();
        CoreSession session = context.getSession();
        AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext octx = new OperationContext(session);
        octx.setInput((Object)blob);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("parent_path", parentDoc.getPathAsString());
        params.put("parent_type", parentDoc.getType());
        try {
            blob = (Blob)as.run(octx, chainId, params);
            String resultStr = (String)octx.get((Object)"FileImporterAutomation_Result");
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                return null;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode resultJson = objectMapper.readTree(resultStr);
            JsonNode docTypeJson = resultJson.get("docType");
            if (docTypeJson == null) {
                return null;
            }
            String docType = docTypeJson.asText();
            if (StringUtils.isBlank((CharSequence)docType)) {
                return null;
            }
            String title = null;
            JsonNode propertiesJson = null;
            if (resultJson.hasNonNull("properties") && (propertiesJson = resultJson.get("properties")).hasNonNull("dc:title")) {
                title = propertiesJson.get("dc:title").asText();
            }
            if (StringUtils.isBlank(title)) {
                title = (String)StringUtils.defaultIfBlank((CharSequence)context.getFileName(), (CharSequence)blob.getFilename());
            }
            doc = session.createDocumentModel(parentDoc.getPathAsString(), title, docType);
            doc.setPropertyValue("dc:title", (Serializable)((Object)title));
            doc.setPropertyValue("file:content", (Serializable)blob);
            if (propertiesJson != null) {
                Properties props = new Properties(propertiesJson);
                DocumentHelper.setProperties((CoreSession)session, (DocumentModel)doc, (Properties)props);
            }
            doc = session.createDocument(doc);
        }
        catch (IOException | OperationException e) {
            throw new NuxeoException("Failed to run the FileManager callback chain <" + chainId + ">", e);
        }
        return doc;
    }

    @Override
    public DocumentModel createFolderish(CoreSession session, String fullname, String path, boolean overwrite, TypeManager typeManager) {
        if (!this.hasAFolderImporterChain()) {
            return null;
        }
        String chainId = this.descriptor.getFolderImporterChain();
        DocumentModel folderish = null;
        String title = FileManagerUtils.fetchFileName((String)fullname);
        PathRef parentRef = new PathRef(path);
        DocumentModel parentDoc = session.getDocument((DocumentRef)parentRef);
        AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext octx = new OperationContext(session);
        octx.setInput((Object)parentDoc);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("title", title);
        try {
            folderish = (DocumentModel)as.run(octx, chainId, params);
        }
        catch (OperationException e) {
            throw new NuxeoException("Failed to run the FileManager callback chain <" + chainId + ">", (Throwable)e);
        }
        return folderish;
    }
}

