/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.fontoxml.servlet;

import com.nuxeo.fontoxml.servlet.FontoXMLServlet;
import com.nuxeo.fontoxml.servlet.ServletUtils;
import com.nuxeo.fontoxml.servlet.Utilities;
import java.io.IOException;
import java.io.Reader;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;

public class DocumentBrowser {
    private static final Log log = LogFactory.getLog(DocumentBrowser.class);
    public static final FastDateFormat FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    protected JSONObject body;
    protected HttpServletResponse response;
    protected JSONObject context;
    protected JSONArray assetTypes;
    protected JSONArray resultTypes;
    protected String folderId;
    protected JSONObject query;
    protected int limit;
    protected int offset;
    protected String currentDocId;
    protected static TagService tagService = null;
    public static final int ALL_RESULTS = -1;

    public DocumentBrowser(HttpServletRequest req, HttpServletResponse response) throws JSONException, IOException {
        String bodyStr = IOUtils.toString((Reader)req.getReader());
        this.body = new JSONObject(bodyStr);
        this.response = response;
        this.context = this.body.getJSONObject("context");
        this.assetTypes = this.body.getJSONArray("assetTypes");
        this.resultTypes = this.body.getJSONArray("resultTypes");
        this.folderId = this.body.optString("folderId", null);
        this.query = this.body.optJSONObject("query");
        this.limit = this.body.optInt("limit", -1);
        this.offset = this.body.optInt("offset", 0);
        this.currentDocId = this.context.optString("documentId", null);
        if (tagService == null) {
            tagService = (TagService)Framework.getService(TagService.class);
        }
    }

    public void browse() throws JSONException, IOException {
        if (this.limit != -1 || this.offset > 0) {
            log.warn((Object)("This Nuxeo-FontoXML POC does not handle paginaiton when browsing the repository from Fonto (limit: " + this.limit + ", offset: " + this.offset + ")"));
        }
        try (CloseableCoreSession session = CoreInstance.openCoreSession(null);){
            String nxql = this.buildNXQL((CoreSession)session);
            if (log.isInfoEnabled()) {
                String msg = "AssetTypes: " + this.assetTypes.toString();
                msg = msg + "\nresultTypes: " + this.resultTypes.toString();
                msg = msg + "NXQL:\n" + nxql;
                log.info((Object)msg);
            }
            ArrayList<String> assetTypesList = new ArrayList<String>();
            for (int i = 0; i < this.assetTypes.length(); ++i) {
                assetTypesList.add(this.assetTypes.getString(i));
            }
            boolean hasFontoFileAssetType = assetTypesList.contains("file");
            String infoMsg = "";
            Iterator iterator = assetTypesList.iterator();
            block33: while (iterator.hasNext()) {
                String assetType;
                switch (assetType = (String)iterator.next()) {
                    case "document": 
                    case "folder": 
                    case "file": 
                    case "image": 
                    case "audio": 
                    case "video": {
                        continue block33;
                    }
                }
                infoMsg = infoMsg + assetType + " ";
            }
            if (infoMsg.length() > 0) {
                log.warn((Object)("This POC does not handle browsing the following: " + infoMsg));
            }
            DocumentModelList docs = session.query(nxql);
            JSONObject results = new JSONObject();
            int totalCount = docs.size();
            JSONArray items = new JSONArray();
            for (DocumentModel oneDoc : docs) {
                boolean gotOne = false;
                JSONObject item = new JSONObject();
                if (oneDoc.hasFacet("Folderish")) {
                    gotOne = true;
                    item.put("id", (Object)oneDoc.getId());
                    item.put("label", (Object)oneDoc.getTitle());
                    item.put("type", (Object)"folder");
                } else if (oneDoc.hasSchema("file")) {
                    Blob blob = (Blob)oneDoc.getPropertyValue("file:content");
                    if (blob != null) {
                        JSONObject metadata = null;
                        JSONObject properties = null;
                        switch (oneDoc.getType()) {
                            case "File": {
                                if (assetTypesList.contains("file")) {
                                    gotOne = true;
                                    break;
                                }
                                if (assetTypesList.contains("document")) {
                                    if (!Utilities.isOkForFontoGETDocument(blob)) break;
                                    gotOne = true;
                                    break;
                                }
                                if (!assetTypesList.contains("output-support") || !Utilities.isOkForFontoPOSTBrowseOutputSupport(blob)) break;
                                gotOne = true;
                                break;
                            }
                            case "Picture": {
                                if (!assetTypesList.contains("image") && !hasFontoFileAssetType) break;
                                gotOne = true;
                                properties = new JSONObject();
                                Map pictInfo = (Map)((Object)oneDoc.getPropertyValue("picture:info"));
                                properties.put("dimension", (Object)(pictInfo.get("width") + "x" + pictInfo.get("height")));
                                break;
                            }
                            case "Video": {
                                if (!assetTypesList.contains("video") && !hasFontoFileAssetType) break;
                                gotOne = true;
                                properties = new JSONObject();
                                Map videoInfo = (Map)((Object)oneDoc.getPropertyValue("vid:info"));
                                properties.put("dimension", (Object)(videoInfo.get("width") + "x" + videoInfo.get("height")));
                                Double duration = (Double)videoInfo.get("duration");
                                if (duration == null) break;
                                LocalTime d = LocalTime.ofSecondOfDay(duration.longValue());
                                StringBuilder buf = new StringBuilder(9);
                                int h = d.getHour();
                                int m = d.getMinute();
                                int s = d.getSecond();
                                buf.append(h < 10 ? "0h" : "h").append(h).append(m < 10 ? "0m" : "m").append(m).append(s < 10 ? "0s" : "s").append(s);
                                properties.put("duration", (Object)buf.toString());
                                break;
                            }
                            case "Audio": {
                                if (!assetTypesList.contains("audio") && !hasFontoFileAssetType) break;
                                gotOne = true;
                            }
                        }
                        if (gotOne) {
                            item.put("id", (Object)oneDoc.getId());
                            item.put("label", (Object)oneDoc.getTitle());
                            item.put("type", (Object)FontoXMLServlet.getFontoType(oneDoc));
                            metadata = new JSONObject();
                            if (properties == null) {
                                properties = new JSONObject();
                            }
                            properties.put("version", (Object)oneDoc.getVersionLabel());
                            properties.put("state", (Object)oneDoc.getCurrentLifeCycleState());
                            Calendar aDate = (Calendar)oneDoc.getPropertyValue("created");
                            properties.put("created", (Object)FORMATTER.format(aDate));
                            aDate = (Calendar)oneDoc.getPropertyValue("dc:modified");
                            properties.put("modified", (Object)FORMATTER.format(aDate));
                            Set tags = tagService.getTags((CoreSession)session, oneDoc.getId());
                            if (tags != null && tags.size() > 0) {
                                properties.put("tags", (Object)String.join((CharSequence)",", tags));
                            }
                            properties.put("fileSize", (Object)FileUtils.byteCountToDisplaySize((long)blob.getLength()));
                            String description = (String)((Object)oneDoc.getPropertyValue("dc:description"));
                            if (StringUtils.isNotBlank((CharSequence)description)) {
                                properties.put("description", (Object)description);
                            }
                            metadata.put("properties", (Object)properties);
                            JSONArray hierarchy = Utilities.buildHierarchy(oneDoc);
                            metadata.put("hierarchy", (Object)hierarchy);
                            item.put("metadata", (Object)metadata);
                        } else {
                            --totalCount;
                        }
                    } else {
                        --totalCount;
                    }
                }
                if (!gotOne) continue;
                items.put((Object)item);
            }
            results.put("totalItemCount", totalCount);
            results.put("items", (Object)items);
            log.info((Object)("Results sent to Fonto:\n" + results.toString(2)));
            ServletUtils.sendStringResponse(this.response, 200, results.toString());
        }
    }

    protected String buildNXQL(CoreSession session) throws JSONException {
        String nxql = "SELECT * FROM DOCUMENT WHERE ecm:isTrashed = 0 AND ecm:isVersion = 0 AND ecm:isProxy = 0 AND ecm:mixinType != 'HiddenInNavigation'";
        if (this.resultTypes.length() == 1) {
            String type;
            switch (type = this.resultTypes.getString(0)) {
                case "folder": {
                    nxql = nxql + " AND ecm:mixinType = 'Folderish'";
                    break;
                }
                case "file": {
                    nxql = nxql + " AND ecm:mixinType != 'Folderish'";
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.folderId)) {
            nxql = nxql + " AND ecm:parentId = '" + this.folderId + "'";
        } else {
            DocumentModel root = session.getDocument((DocumentRef)new PathRef("/"));
            nxql = nxql + " AND ecm:parentId = '" + root.getId() + "'";
        }
        nxql = nxql + " ORDER BY dc:title ASC";
        return nxql;
    }
}

