/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.fontoxml;

import com.nuxeo.fontoxml.FontoXMLConfigDescriptor;
import com.nuxeo.fontoxml.FontoXMLService;
import com.nuxeo.fontoxml.servlet.Utilities;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.features.PlatformFunctions;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class FontoXMLServiceImpl
extends DefaultComponent
implements FontoXMLService {
    public static final String EXT_POINT = "configuration";
    protected FontoXMLConfigDescriptor config = null;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EXT_POINT.equals(extensionPoint)) {
            this.config = (FontoXMLConfigDescriptor)contribution;
        }
    }

    public FontoXMLConfigDescriptor getConfiguration() {
        return this.config;
    }

    @Override
    public Blob getRendition(CoreSession session, DocumentModel doc) {
        String xpath;
        PictureView pv;
        MultiviewPicture mvp;
        String defaultRendition;
        Blob blob = null;
        if (this.config == null) {
            throw new NuxeoException("No XML configuration loaded");
        }
        String chainId = this.config.getRenditionCallbackChain();
        if (StringUtils.isNotBlank((CharSequence)chainId)) {
            AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
            OperationContext octx = new OperationContext(session);
            octx.setInput((Object)doc);
            try {
                blob = (Blob)as.run(octx, chainId);
            }
            catch (OperationException e) {
                throw new NuxeoException("Failed to run the callback chain", (Throwable)e);
            }
        }
        if (blob == null && StringUtils.isNotBlank((CharSequence)(defaultRendition = this.config.getDefaultRendition())) && (mvp = (MultiviewPicture)doc.getAdapter(MultiviewPicture.class)) != null && (pv = mvp.getView(defaultRendition)) != null) {
            blob = pv.getBlob();
        }
        if (blob == null && StringUtils.isNotBlank((CharSequence)(xpath = this.config.getRenditionXPath()))) {
            blob = (Blob)doc.getPropertyValue(xpath);
        }
        if (blob == null && doc.hasSchema("file")) {
            blob = (Blob)doc.getPropertyValue("file:content");
        }
        if (blob != null && blob.getMimeType() == null) {
            String string = Utilities.getBlobMimeType(blob, true);
        }
        return blob;
    }

    protected DocumentModel createDocument(CoreSession session, Blob content, DocumentModel mainDoc, DocumentModel folder, boolean isAsset) throws IOException {
        DocumentModel doc = null;
        if (this.config == null) {
            throw new NuxeoException("No XML configuration loaded");
        }
        String xmlDocType = this.config.getTypeForNewXMLDocument();
        String chainId = this.config.getDocumentCreationCallbackChain();
        if (StringUtils.isNotBlank((CharSequence)chainId)) {
            AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
            OperationContext octx = new OperationContext(session);
            octx.setInput((Object)content);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("mainDocId", mainDoc == null ? null : mainDoc.getId());
            parameters.put("folderId", folder == null ? null : folder.getId());
            parameters.put("isAsset", false);
            if (!isAsset) {
                parameters.put("docTypeForNewXML", xmlDocType);
            }
            try {
                doc = (DocumentModel)as.run(octx, chainId, parameters);
                return doc;
            }
            catch (OperationException e) {
                throw new NuxeoException("Failed to run the " + chainId + " callback chain", (Throwable)e);
            }
        }
        DocumentModel container = null;
        if (folder != null) {
            container = folder;
        }
        if (container == null && mainDoc != null) {
            container = mainDoc.isFolder() ? mainDoc : session.getParentDocument(mainDoc.getParentRef());
        }
        if (container == null) {
            throw new NuxeoException("Cannot find a container for the new document");
        }
        if (!isAsset && content.getFilename() == null) {
            PlatformFunctions pf = new PlatformFunctions();
            String fileName = "XML-Doc-" + pf.getNextId("FontoPostDocument") + ".xml";
            content.setFilename(fileName);
        }
        String fileName = content.getFilename();
        if (isAsset || StringUtils.isBlank((CharSequence)xmlDocType)) {
            FileManager fileManager = (FileManager)Framework.getService(FileManager.class);
            FileImporterContext context = FileImporterContext.builder((CoreSession)session, (Blob)content, (String)container.getPathAsString()).overwrite(true).fileName(fileName).build();
            doc = fileManager.createOrUpdateDocument(context);
        } else {
            doc = session.createDocumentModel(container.getPathAsString(), fileName, xmlDocType);
            doc.setPropertyValue("dc:title", (Serializable)((Object)fileName));
            doc.setPropertyValue("file:content", (Serializable)content);
            doc = session.createDocument(doc);
            session.save();
        }
        return doc;
    }

    @Override
    public DocumentModel createDocument(CoreSession session, Blob content, DocumentModel mainDoc, DocumentModel folder) throws IOException {
        return this.createDocument(session, content, mainDoc, folder, false);
    }

    @Override
    public DocumentModel createAsset(CoreSession session, Blob content, DocumentModel mainDoc, DocumentModel folder) throws IOException {
        return this.createDocument(session, content, mainDoc, folder, true);
    }

    @Override
    public DocumentModel handleOutput(CoreSession session, DocumentModel doc, DocumentModel mainDoc) {
        String chainId = this.config.getOutputCreationCallbackChain();
        if (StringUtils.isNotBlank((CharSequence)chainId)) {
            AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
            OperationContext octx = new OperationContext(session);
            octx.setInput((Object)doc);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("mainDocId", mainDoc == null ? null : mainDoc.getId());
            try {
                doc = (DocumentModel)as.run(octx, chainId, parameters);
                return doc;
            }
            catch (OperationException e) {
                throw new NuxeoException("Failed to run the " + chainId + " callback chain", (Throwable)e);
            }
        }
        return doc;
    }
}

