/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.fontoxml.servlet;

import com.nuxeo.fontoxml.servlet.Constants;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class Utilities {
    public static String getBlobMimeType(Blob blob, boolean setIfEmpty) {
        if (blob == null) {
            return null;
        }
        String mimeType = blob.getMimeType();
        if (StringUtils.isNotBlank((CharSequence)mimeType)) {
            return mimeType;
        }
        String fileName = blob.getFilename();
        if (fileName != null) {
            for (String ext : Constants.FONTO_DOCUMENT_FILE_EXTENSIONS_ARE_XML) {
                if (!fileName.endsWith(ext)) continue;
                mimeType = "text/xml";
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            MimetypeRegistry mimeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            try {
                mimeType = mimeRegistry.getMimetypeFromBlob(blob);
            }
            catch (MimetypeDetectionException | MimetypeNotFoundException e1) {
                try {
                    mimeType = mimeRegistry.getMimetypeFromFile(blob.getFile());
                }
                catch (MimetypeDetectionException | MimetypeNotFoundException e2) {
                    throw new NuxeoException("Cannot get a Mime Type from the blob or the file", e2);
                }
            }
        }
        if (setIfEmpty) {
            blob.setMimeType(mimeType);
        }
        return mimeType;
    }

    public static boolean looksLikeXml(Blob blob) {
        if (blob == null) {
            return false;
        }
        String mimeType = Utilities.getBlobMimeType(blob, true);
        return mimeType.startsWith("application/xml") || mimeType.endsWith("xml");
    }

    public static boolean canGetString(Blob blob) {
        if (blob == null) {
            return false;
        }
        String mimeType = Utilities.getBlobMimeType(blob, true);
        return mimeType.startsWith("text/") || Utilities.looksLikeXml(blob);
    }

    public static boolean isOkForFontoGETDocument(Blob blob) {
        if (!Utilities.canGetString(blob)) {
            return false;
        }
        String fileName = blob.getFilename();
        if (fileName != null) {
            for (String fileExt : Constants.FONTO_DOCUMENT_FILE_EXTENSIONS) {
                if (!fileName.endsWith(fileExt)) continue;
                return true;
            }
        }
        return Utilities.looksLikeXml(blob);
    }

    public static boolean isOkForFontoPOSTBrowseOutputSupport(Blob blob) {
        if (!Utilities.canGetString(blob)) {
            return false;
        }
        String fileName = blob.getFilename();
        if (fileName != null) {
            for (String fileExt : Constants.FONTO_OUTPUTSUPPORT_FILE_EXTENSIONS) {
                if (!fileName.endsWith(fileExt)) continue;
                return true;
            }
        }
        return false;
    }

    public static JSONArray buildHierarchy(DocumentModel doc) throws JSONException {
        JSONArray array = new JSONArray();
        List parents = doc.getCoreSession().getParentDocuments(doc.getRef());
        for (DocumentModel aParent : parents) {
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)aParent.getId());
            obj.put("label", (Object)aParent.getTitle());
            if (aParent.isFolder()) {
                obj.put("type", (Object)"folder");
            } else {
                obj.put("type", (Object)"file");
            }
            array.put((Object)obj);
        }
        return array;
    }
}

