/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.fontoxml.servlet;

import com.nuxeo.fontoxml.FontoXMLService;
import com.nuxeo.fontoxml.servlet.DocumentBrowser;
import com.nuxeo.fontoxml.servlet.EditSessionToken;
import com.nuxeo.fontoxml.servlet.ServletUtils;
import com.nuxeo.fontoxml.servlet.Utilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.LockException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailService;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.runtime.api.Framework;

public class FontoXMLServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FontoXMLServlet.class);
    protected final DateFormat dateFormatForFile = new SimpleDateFormat("yyyy-MM-dd'-'HH'h'mm'm'ss's'");
    protected static boolean includAddDocsWarningSent = false;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        log.info((Object)("GET " + path));
        switch (path) {
            case "/document": {
                this.handleGetDocument(req, resp);
                break;
            }
            case "/asset": {
                this.handleGetAsset(req, resp, false);
                break;
            }
            case "/asset/preview": {
                this.handleGetAssetPreview(req, resp);
                break;
            }
            case "/heartbeat": {
                ServletUtils.sendOKStringResponse(resp, null);
                break;
            }
            default: {
                log.warn((Object)("GET " + path + ", not handled"));
                resp.sendError(404);
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        log.info((Object)("POST " + path));
        switch (path) {
            case "/document": {
                this.handlePostDocument(req, resp);
                break;
            }
            case "/browse": {
                try {
                    DocumentBrowser browser = new DocumentBrowser(req, resp);
                    browser.browse();
                    break;
                }
                catch (JSONException e) {
                    throw new NuxeoException("Failed to json-parse a string", (Throwable)e);
                }
            }
            case "/asset": {
                this.handlePostAsset(req, resp);
                break;
            }
            case "/document/state": {
                this.handlePostDocumentState(req, resp);
                break;
            }
            default: {
                log.warn((Object)("POST " + path + ", not handled"));
                resp.sendError(404);
            }
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        log.info((Object)("PUT " + path));
        switch (path) {
            case "/document": {
                this.handlePutDocument(req, resp);
                break;
            }
            case "/document/lock": {
                this.handlePutDocumentLock(req, resp);
                break;
            }
            default: {
                log.warn((Object)("PUT " + path + ", not handled"));
                resp.sendError(404);
            }
        }
    }

    public JSONObject getLockInfoForFonto(DocumentModel doc) throws JSONException {
        JSONObject lock = new JSONObject();
        if (doc.isLocked()) {
            Lock docLockInfo = doc.getLockInfo();
            if (docLockInfo.getOwner().equals(doc.getCoreSession().getPrincipal().getName())) {
                lock.put("isLockAcquired", true);
                lock.put("isLockAvailable", true);
            } else {
                lock.put("isLockAcquired", false);
                lock.put("isLockAvailable", false);
                lock.put("reason", (Object)"The document is locked by another user.");
            }
        } else {
            lock.put("isLockAcquired", false);
            if (doc.getCoreSession().hasPermission(doc.getRef(), "Write")) {
                lock.put("isLockAvailable", true);
            } else {
                lock.put("isLockAvailable", false);
                lock.put("reason", (Object)"The document cannot be modified by this user");
            }
        }
        return lock;
    }

    protected void handleGetDocument(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String docId = req.getParameter("documentId");
        String includeAdditionalDocuments = req.getParameter("includeAdditionalDocuments");
        if (includeAdditionalDocuments != null && includeAdditionalDocuments.equals("true") && !includAddDocsWarningSent) {
            includAddDocsWarningSent = true;
            log.warn((Object)"\n====================================================================\n includeAdditionalDocuments parameter is not support in this version.\n(This warning is displayed only once.)\n====================================================================");
        }
        try (CloseableCoreSession session = CoreInstance.openCoreSession(null);){
            IdRef docRef = new IdRef(docId);
            if (!session.exists((DocumentRef)docRef)) {
                log.warn((Object)("docId <" + docId + "> not found"));
                resp.sendError(404, "Document not found");
                return;
            }
            DocumentModel doc = session.getDocument((DocumentRef)docRef);
            Blob blob = (Blob)doc.getPropertyValue("file:content");
            if (blob == null) {
                log.warn((Object)(doc.getTitle() + "/" + docId + " has no blob"));
                resp.sendError(404, "This document has no blob");
                return;
            }
            if (!Utilities.canGetString(blob)) {
                log.warn((Object)(doc.getTitle() + "/" + docId + " => Not a text-based blob"));
                resp.sendError(404, "Not a text-based blob");
                return;
            }
            String blobStr = blob.getString();
            JSONObject responseJson = new JSONObject();
            responseJson.put("documentId", (Object)docId);
            responseJson.put("content", (Object)blobStr);
            JSONObject lock = this.getLockInfoForFonto(doc);
            responseJson.put("lock", (Object)lock);
            FontoDocumentContext documentContext = new FontoDocumentContext(doc, lock);
            responseJson.put("documentContext", (Object)documentContext.toJSON());
            JSONObject metadata = new JSONObject();
            JSONArray hierarchy = Utilities.buildHierarchy(doc);
            metadata.put("hierarchy", (Object)hierarchy);
            responseJson.put("metadata", (Object)metadata);
            String response = responseJson.toString();
            ServletUtils.sendOKStringResponse(resp, response);
        }
        catch (JSONException e) {
            throw new NuxeoException("Failed to json-parse the <context> parameter", (Throwable)e);
        }
    }

    protected void handleGetAssetPreview(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handleGetAsset(req, resp, true);
    }

    protected void handleGetAsset(HttpServletRequest req, HttpServletResponse resp, boolean isGetPreview) throws IOException {
        String context = req.getParameter("context");
        String assetId = req.getParameter("id");
        try {
            JSONObject contextJson = new JSONObject(context);
            String mainDocId = contextJson.optString("documentId");
            try (CloseableCoreSession session = CoreInstance.openCoreSession(null);){
                IdRef assetDocRef = new IdRef(assetId);
                if (!session.exists((DocumentRef)assetDocRef)) {
                    log.warn((Object)("Asset Id " + assetId + " not found"));
                    resp.sendError(404, "Document not found");
                    return;
                }
                DocumentModel asset = session.getDocument((DocumentRef)assetDocRef);
                if (!asset.hasSchema("file")) {
                    log.warn((Object)("Asset ID " + assetId + " (" + asset.getTitle() + ") does not have the <file> schema???"));
                    resp.sendError(500, "Asset does not have the 'file' schema");
                    return;
                }
                Blob assetBlob = null;
                if (isGetPreview) {
                    assetBlob = this.getAssetPreview((CoreSession)session, asset, req.getParameter("variant"));
                } else {
                    FontoXMLService fontoService = (FontoXMLService)Framework.getService(FontoXMLService.class);
                    assetBlob = fontoService.getRendition((CoreSession)session, asset);
                }
                if (assetBlob == null) {
                    log.warn((Object)("Asset ID " + assetId + " (" + asset.getTitle() + ") => no rendition found to send back to FontoXML"));
                    resp.sendError(404, "Asset has no rendition for FontoXML");
                    return;
                }
                String fileName = (String)StringUtils.defaultIfBlank((CharSequence)assetBlob.getFilename(), (CharSequence)"file");
                String contentDisposition = DownloadHelper.getRFC2231ContentDisposition((HttpServletRequest)req, (String)fileName, null);
                resp.setHeader("Content-Disposition", contentDisposition);
                resp.setContentType(assetBlob.getMimeType());
                resp.setContentLengthLong(assetBlob.getLength());
                ServletOutputStream out = resp.getOutputStream();
                IOUtils.copy((InputStream)assetBlob.getStream(), (OutputStream)out);
                out.close();
                resp.setStatus(200);
            }
        }
        catch (JSONException e) {
            throw new NuxeoException("Failed to json-parse the <context> parameter", (Throwable)e);
        }
    }

    protected Blob getAssetPreview(CoreSession session, DocumentModel asset, String variant) {
        Blob blob = null;
        log.info((Object)("variant: " + variant));
        blob = ((ThumbnailService)Framework.getService(ThumbnailService.class)).getThumbnail(asset, session);
        if (blob == null) {
            log.warn((Object)("Asset ID " + asset.getId() + " (" + asset.getTitle() + ") => cannot get a thumbnail"));
            return null;
        }
        ImagingService imagingService = (ImagingService)Framework.getService(ImagingService.class);
        ImageInfo imageInfo = imagingService.getImageInfo(blob);
        log.info((Object)("Thumbnail size: " + imageInfo.getWidth() + "x" + imageInfo.getHeight()));
        String thumbnailMimeType = blob.getMimeType();
        switch (variant) {
            case "thumbnail": {
                if (imageInfo.getWidth() == 128 && imageInfo.getHeight() == 128) break;
                log.info((Object)"RESIZING TO 128x128");
                blob = imagingService.resize(blob, imageInfo.getFormat(), 128, 128, -1);
                blob.setMimeType(thumbnailMimeType);
                break;
            }
            case "web": {
                if (imageInfo.getWidth() <= 1024 && imageInfo.getHeight() <= 1024) break;
                log.info((Object)"RESIZING TO max 1024x1024");
                blob = imagingService.resize(blob, imageInfo.getFormat(), 1024, 1024, -1);
                blob.setMimeType(thumbnailMimeType);
                break;
            }
            default: {
                log.warn((Object)("Unhandled variant: " + variant));
            }
        }
        return blob;
    }

    protected void handlePostDocument(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String body = IOUtils.toString((Reader)req.getReader());
        try {
            JSONObject bodyJson = new JSONObject(body);
            JSONObject context = bodyJson.getJSONObject("context");
            String content = bodyJson.getString("content");
            String folderId = bodyJson.optString("folderId");
            JSONObject metadata = bodyJson.optJSONObject("metadata");
            try (CloseableCoreSession session = CoreInstance.openCoreSession(null);){
                Object fileName;
                IdRef docRef;
                DocumentModel mainDoc = null;
                DocumentModel folder = null;
                EditSessionToken esToken = new EditSessionToken(context.getString("editSessionToken"));
                mainDoc = esToken.getMainDocument((CoreSession)session);
                if (StringUtils.isNotBlank((CharSequence)folderId) && session.exists((DocumentRef)(docRef = new IdRef(folderId)))) {
                    folder = session.getDocument((DocumentRef)docRef);
                }
                Blob blob = Blobs.createBlob((String)content);
                blob.setMimeType(null);
                if (metadata != null) {
                    fileName = metadata.optString("fileName");
                    String fileExtension = metadata.optString("fileExtension");
                    if (StringUtils.isNotBlank((CharSequence)fileName) && StringUtils.isNotBlank((CharSequence)fileExtension)) {
                        if (!fileExtension.startsWith(".")) {
                            fileName = (String)fileName + ".";
                        }
                        fileName = (String)fileName + fileExtension;
                    }
                    blob.setFilename((String)fileName);
                    Utilities.getBlobMimeType(blob, true);
                }
                if (blob.getMimeType() == null) {
                    Utilities.getBlobMimeType(blob, true);
                }
                if (metadata != null && metadata.optBoolean("skipProcessing") && mainDoc != null) {
                    fileName = mainDoc.getTitle();
                    String baseName = StringUtils.substringBefore((String)fileName, (String)".");
                    String ext = FilenameUtils.getExtension((String)blob.getFilename());
                    String formatedISO = this.dateFormatForFile.format(new Date());
                    blob.setFilename(baseName + "-output-" + formatedISO + "." + ext);
                }
                FontoXMLService fontoService = (FontoXMLService)Framework.getService(FontoXMLService.class);
                DocumentModel newDoc = fontoService.createDocument((CoreSession)session, blob, mainDoc, folder);
                if (metadata != null && metadata.optBoolean("skipProcessing")) {
                    newDoc = fontoService.handleOutput((CoreSession)session, newDoc, mainDoc);
                }
                JSONObject responseJson = new JSONObject();
                responseJson.put("documentId", (Object)newDoc.getId());
                responseJson.put("content", (Object)content);
                JSONObject lock = this.getLockInfoForFonto(newDoc);
                responseJson.put("lock", (Object)lock);
                FontoDocumentContext documentContext = new FontoDocumentContext(newDoc, lock);
                responseJson.put("documentContext", (Object)documentContext.toJSON());
                String response = responseJson.toString();
                ServletUtils.sendStringResponse(resp, 201, response);
            }
        }
        catch (JSONException e) {
            throw new NuxeoException("Failed to json-parse a string", (Throwable)e);
        }
    }

    protected void handlePostAsset(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String body = IOUtils.toString((Reader)req.getReader());
        Part request = req.getPart("request");
        Part file = req.getPart("file");
        String requestStr = IOUtils.toString((InputStream)request.getInputStream(), (Charset)Charset.forName("UTF-8"));
        try {
            JSONObject requestJson = new JSONObject(requestStr);
            JSONObject context = requestJson.getJSONObject("context");
            String type = requestJson.getString("type");
            String folderId = requestJson.optString("folderId", null);
            String docId = context.getString("documentId");
            try (CloseableCoreSession session = CoreInstance.openCoreSession(null);){
                IdRef docRef;
                DocumentModel mainDoc = null;
                DocumentModel folder = null;
                EditSessionToken esToken = new EditSessionToken(context.getJSONObject("editSessionToken"));
                mainDoc = esToken.getMainDocument((CoreSession)session);
                if (StringUtils.isNotBlank((CharSequence)folderId) && session.exists((DocumentRef)(docRef = new IdRef(folderId)))) {
                    folder = session.getDocument((DocumentRef)docRef);
                }
                Blob blob = ServletUtils.createBlobFromPart(file);
                FontoXMLService fontoService = (FontoXMLService)Framework.getService(FontoXMLService.class);
                DocumentModel asset = fontoService.createAsset((CoreSession)session, blob, mainDoc, folder);
                JSONObject result = new JSONObject();
                result.put("id", (Object)asset.getId());
                result.put("label", (Object)asset.getTitle());
                switch (asset.getType()) {
                    case "File": {
                        break;
                    }
                    case "Picture": {
                        result.put("type", (Object)"image");
                        break;
                    }
                    case "Audio": {
                        result.put("type", (Object)"audio");
                        break;
                    }
                    case "Video": {
                        result.put("type", (Object)"video");
                        break;
                    }
                    default: {
                        result.put("type", (Object)"unknown");
                    }
                }
                String response = result.toString();
                ServletUtils.sendStringResponse(resp, 201, response);
            }
        }
        catch (JSONException e) {
            throw new NuxeoException("Failed to json-parse a string", (Throwable)e);
        }
    }

    protected void handlePostDocumentState(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String body = IOUtils.toString((Reader)req.getReader());
        try {
            JSONObject bodyJson = new JSONObject(body);
            JSONArray documents = bodyJson.getJSONArray("documents");
            JSONArray results = new JSONArray();
            int max = documents.length();
            for (int i = 0; i < max; ++i) {
                JSONObject oneDocInfo = documents.getJSONObject(i);
                JSONObject documentContext = oneDocInfo.getJSONObject("documentContext");
                JSONObject lockInfo = documentContext.getJSONObject("lockInfo");
                JSONObject bodyResult = new JSONObject();
                bodyResult.put("documentContext", (Object)documentContext);
                bodyResult.put("lock", (Object)lockInfo);
                JSONObject oneResult = new JSONObject();
                oneResult.put("status", 200);
                oneResult.put("body", (Object)bodyResult);
                results.put(i, (Object)oneResult);
            }
            JSONObject responseJson = new JSONObject();
            responseJson.put("results", (Object)results);
            String response = responseJson.toString();
            ServletUtils.sendOKStringResponse(resp, response);
        }
        catch (JSONException e) {
            throw new NuxeoException("Failed to json-parse a string", (Throwable)e);
        }
    }

    protected void handlePutDocument(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String body = IOUtils.toString((Reader)req.getReader());
        try {
            JSONObject bodyJson = new JSONObject(body);
            try (CloseableCoreSession session = CoreInstance.openCoreSession(null);){
                JSONObject context = bodyJson.getJSONObject("context");
                String docId = bodyJson.getString("documentId");
                String xmlContent = bodyJson.getString("content");
                boolean autosave = bodyJson.optBoolean("autosave");
                JSONObject documentContext = bodyJson.getJSONObject("documentContext");
                String revisionId = bodyJson.optString("revisionId", null);
                JSONObject metadata = bodyJson.optJSONObject("metadata");
                IdRef docRef = new IdRef(docId);
                if (!session.exists((DocumentRef)docRef)) {
                    log.warn((Object)("docId " + docId + " not found"));
                    ServletUtils.sendStringResponse(resp, 404, null);
                } else {
                    DocumentModel doc = session.getDocument((DocumentRef)docRef);
                    Blob blob = (Blob)doc.getPropertyValue("file:content");
                    StringBlob newBlob = new StringBlob(xmlContent, "text/xml");
                    newBlob.setFilename(blob.getFilename());
                    doc.setPropertyValue("file:content", (Serializable)newBlob);
                    doc = session.saveDocument(doc);
                    session.save();
                    DocumentEventContext eventCtx = new DocumentEventContext((CoreSession)session, session.getPrincipal(), doc);
                    Event eventToSend = eventCtx.newEvent("documentModifiedByFontoXML");
                    doc.putContextData("isFontoAutoSave", (Serializable)Boolean.valueOf(autosave));
                    ((EventService)Framework.getService(EventService.class)).fireEvent(eventToSend);
                    if (documentContext != null || StringUtils.isNotBlank((CharSequence)revisionId)) {
                        JSONObject bodyResult = new JSONObject();
                        if (documentContext != null) {
                            bodyResult.put("documentContext", (Object)documentContext);
                        }
                        if (StringUtils.isNotBlank((CharSequence)revisionId)) {
                            bodyResult.put("revisionId", (Object)revisionId);
                        }
                        ServletUtils.sendStringResponse(resp, 200, bodyResult.toString());
                    } else {
                        ServletUtils.sendStringResponse(resp, 204, null);
                    }
                }
            }
        }
        catch (JSONException e) {
            throw new NuxeoException("Failed to json-parse a string", (Throwable)e);
        }
    }

    protected void handlePutDocumentLock(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block20: {
            String body = IOUtils.toString((Reader)req.getReader());
            try {
                JSONObject bodyJson = new JSONObject(body);
                try (CloseableCoreSession session = CoreInstance.openCoreSession(null);){
                    DocumentModel doc;
                    boolean lockRemoved;
                    boolean isLockedByMe;
                    JSONObject documentContext;
                    String revisionId;
                    block21: {
                        JSONObject context = bodyJson.getJSONObject("context");
                        String docId = bodyJson.getString("documentId");
                        JSONObject lock = bodyJson.getJSONObject("lock");
                        boolean acquireLock = lock.getBoolean("isLockAcquired");
                        revisionId = bodyJson.optString("revisionId", null);
                        documentContext = bodyJson.getJSONObject("documentContext");
                        IdRef docRef = new IdRef(docId);
                        if (!session.exists((DocumentRef)docRef)) {
                            log.warn((Object)("docId " + docId + " not found"));
                            ServletUtils.sendStringResponse(resp, 404, null);
                            break block20;
                        }
                        isLockedByMe = false;
                        lockRemoved = false;
                        doc = session.getDocument((DocumentRef)docRef);
                        if (acquireLock) {
                            try {
                                if (!doc.isLocked()) {
                                    Lock docLock = session.setLock((DocumentRef)docRef);
                                    isLockedByMe = true;
                                    break block21;
                                }
                                Lock lockInfo = doc.getLockInfo();
                                isLockedByMe = lockInfo.getOwner().equals(session.getPrincipal().getName());
                            }
                            catch (LockException lockInfo) {}
                        } else {
                            try {
                                doc.removeLock();
                                lockRemoved = true;
                            }
                            catch (LockException lockInfo) {
                                // empty catch block
                            }
                        }
                    }
                    JSONObject lockInfoForFonto = this.getLockInfoForFonto(doc);
                    documentContext.put("lockInfo", (Object)lockInfoForFonto);
                    if (isLockedByMe || lockRemoved) {
                        JSONObject bodyResult = null;
                        bodyResult = new JSONObject();
                        if (documentContext != null) {
                            bodyResult.put("documentContext", (Object)documentContext);
                        }
                        if (StringUtils.isNotBlank((CharSequence)revisionId)) {
                            bodyResult.put("revisionId", (Object)revisionId);
                        }
                        ServletUtils.sendStringResponse(resp, 200, bodyResult.toString());
                    } else {
                        ServletUtils.sendStringResponse(resp, 403, null);
                    }
                }
            }
            catch (JSONException e) {
                throw new NuxeoException("Failed to json-parse a string", (Throwable)e);
            }
        }
    }

    public void init() throws ServletException {
        log.info((Object)"Ready.");
    }

    public static String getFontoType(DocumentModel doc) {
        if (doc.hasFacet("Folderish")) {
            return "folder";
        }
        if (!doc.hasSchema("file")) {
            return "unknown";
        }
        Blob blob = (Blob)doc.getPropertyValue("file:content");
        if (blob == null) {
            return "unknown";
        }
        switch (doc.getType()) {
            case "File": {
                String mimeType = blob.getMimeType();
                if (mimeType != null && mimeType.equals("text/xml")) {
                    return "document";
                }
                return "file";
            }
            case "Picture": {
                return "image";
            }
            case "Audio": {
                return "audio";
            }
            case "Video": {
                return "video";
            }
        }
        return "unknown";
    }

    protected class FontoDocumentContext {
        DocumentModel doc;
        JSONObject documentContext;

        FontoDocumentContext(DocumentModel doc, JSONObject lock) throws JSONException {
            this.doc = doc;
            this.documentContext = new JSONObject();
            this.documentContext.put("lockInfo", (Object)lock);
            this.documentContext.put("uuid", (Object)doc.getId());
            this.documentContext.put("type", (Object)doc.getType());
            this.documentContext.put("state", (Object)doc.getCurrentLifeCycleState());
        }

        public JSONObject toJSON() {
            return this.documentContext;
        }
    }
}

