/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.fontoxml.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;

public class ServletUtils {
    public static void sendStringResponse(HttpServletResponse resp, int status, String response) throws IOException {
        resp.setStatus(status);
        if (StringUtils.isNotBlank((CharSequence)response)) {
            resp.setContentType("application/json");
            resp.setContentLength(response.getBytes().length);
            ServletOutputStream out = resp.getOutputStream();
            out.write(response.getBytes());
            out.close();
        }
    }

    public static void sendOKStringResponse(HttpServletResponse resp, String response) throws IOException {
        ServletUtils.sendStringResponse(resp, 200, response);
    }

    public static Blob createBlobFromPart(Part part) throws IOException {
        Blob b = null;
        b = Blobs.createBlob((InputStream)part.getInputStream());
        b.setFilename(ServletUtils.retrieveFilename(part));
        b.setMimeType(part.getContentType());
        return b;
    }

    public static String retrieveFilename(Part part) {
        for (String cd : part.getHeader("content-disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            String filename = cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
            return ServletUtils.getCleanFileName(filename);
        }
        return null;
    }

    public static String getCleanFileName(String filename) {
        int lastUnixSeparator;
        String res = null;
        int lastWinSeparator = filename.lastIndexOf(92);
        int lastSeparator = Math.max(lastWinSeparator, lastUnixSeparator = filename.lastIndexOf(47));
        res = lastSeparator != -1 ? filename.substring(lastSeparator + 1, filename.length()) : filename;
        return res;
    }
}

