/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.generative.ai.openai;

import com.theokanning.openai.OpenAiHttpException;
import com.theokanning.openai.image.CreateImageRequest;
import com.theokanning.openai.image.Image;
import com.theokanning.openai.service.OpenAiService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.generative.ai.GenerativeAIProvider;
import org.nuxeo.generative.ai.GenerativeAIProviderDescriptor;
import org.nuxeo.runtime.api.Framework;

public class OpenAIProvider
implements GenerativeAIProvider {
    private static final Log log = LogFactory.getLog(OpenAIProvider.class);
    public static final String ORGANIZATION_CONF_PARAM = "generative.ai.openai.organization";
    public static final String API_KEY_CONF_PARAM = "generative.ai.openai.apikey";
    public static final String ENV_VAR_ORGANIZATION = "NUXEO_GENERATIVE_AI_OPENAI_ORGANIZATION";
    public static final String ENV_VAR_APIKEY = "NUXEO_GENERATIVE_AI_OPENAI_APIKEY";
    protected String organization = null;
    protected String apiKey = null;
    protected OpenAiService service = null;
    protected GenerativeAIProviderDescriptor descriptor;

    public OpenAIProvider(GenerativeAIProviderDescriptor desc) {
        this.descriptor = desc;
        Map<String, String> params = desc.getParameters();
        if (params != null) {
            this.organization = params.get("organization");
            if (StringUtils.isBlank((CharSequence)this.organization)) {
                this.organization = Framework.getProperty((String)ORGANIZATION_CONF_PARAM);
            }
            if (StringUtils.isBlank((CharSequence)this.organization)) {
                this.organization = System.getProperty(ENV_VAR_ORGANIZATION);
            }
            this.apiKey = params.get("apiKey");
            if (StringUtils.isBlank((CharSequence)this.apiKey)) {
                this.apiKey = Framework.getProperty((String)API_KEY_CONF_PARAM);
            }
            if (StringUtils.isBlank((CharSequence)this.apiKey)) {
                this.apiKey = System.getProperty(ENV_VAR_APIKEY);
            }
            if (StringUtils.isBlank((CharSequence)this.apiKey)) {
                log.error((Object)"Api Key for calling OpenAI is empty => all call will fail and will not be performed");
            } else {
                this.service = new OpenAiService(this.apiKey);
            }
        }
    }

    protected boolean checkApiKey() {
        if (StringUtils.isBlank((CharSequence)this.apiKey)) {
            log.warn((Object)"OpenAI API Key is not valid => not calling the service");
            return false;
        }
        return true;
    }

    @Override
    public Blob generateImage(String prompt, String size) throws IOException {
        Blob result = null;
        if (!this.checkApiKey()) {
            log.error((Object)"No API key configured, returning null");
            return null;
        }
        CreateImageRequest request = CreateImageRequest.builder().prompt(prompt).n(Integer.valueOf(1)).size(size).build();
        List images = null;
        try {
            images = this.service.createImage(request).getData();
            Image image = null;
            if (images.size() > 0) {
                image = (Image)images.get(0);
            }
            if (image != null) {
                image.getUrl();
                result = GenerativeAIProvider.downloadFile(image.getUrl(), "", "OpenAI");
            }
        }
        catch (OpenAiHttpException e) {
            log.error((Object)"Can not generate image: ", (Throwable)e);
            throw new NuxeoException((Throwable)e);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }
}

