/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.glb.adapter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.labs.glb.adapter.GLBRendition;

public class GLBModelAdapter {
    protected DocumentModel doc;

    public GLBModelAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    public List<GLBRendition> getRenditions() {
        List<Map<String, Serializable>> renditions = this.getStoredRenditions();
        return renditions.stream().map(GLBRendition::new).collect(Collectors.toList());
    }

    public GLBRendition getRendition(String name) {
        List<Map<String, Serializable>> renditions = this.getStoredRenditions();
        Optional<GLBRendition> result = renditions.stream().map(GLBRendition::new).filter(entry -> entry.name != null && entry.name.equals(name)).findFirst();
        return result.orElse(null);
    }

    public void addRendition(GLBRendition rendition) {
        List<Map<String, Serializable>> renditions = this.getStoredRenditions();
        renditions.add(rendition.toMap());
        this.setStoredRenditions(renditions);
    }

    public void clearRenditions() {
        this.doc.setPropertyValue("glb:renditions", null);
    }

    protected List<Map<String, Serializable>> getStoredRenditions() {
        return (List)((Object)this.doc.getPropertyValue("glb:renditions"));
    }

    protected void setStoredRenditions(List<Map<String, Serializable>> values) {
        this.doc.setPropertyValue("glb:renditions", (Serializable)((Object)values));
    }
}

