/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.glb.worker;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.labs.glb.adapter.GLBModelAdapter;
import org.nuxeo.labs.glb.adapter.GLBRendition;
import org.nuxeo.runtime.api.Framework;

public class GLBConversionWork
extends AbstractWork {
    public static final String GLB_CONVERSION_DONE_EVENT = "GLBConversionDone";
    private static final Logger log = LogManager.getLogger(GLBConversionWork.class);
    public static final String OPTIMIZED_RENDITION_NAME = "optimized";
    public static final String CATEGORY = "glbConversion";

    protected static String computeIdPrefix(String repositoryName, String docId) {
        return repositoryName + ":" + docId + ":glbconversion:";
    }

    public GLBConversionWork(String repositoryName, String docId) {
        super(GLBConversionWork.computeIdPrefix(repositoryName, docId));
        this.setDocument(repositoryName, docId);
    }

    public String getCategory() {
        return CATEGORY;
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.openSystemSession();
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        Blob glb = blobHolder.getBlob();
        this.setStatus("Updating previews");
        this.computePreviews(doc, glb);
        if (doc.isVersion()) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        this.session.saveDocument(doc);
        this.setStatus("Done");
        this.fireGLBConversionDoneEvent();
    }

    public int getRetryCount() {
        return 2;
    }

    public String getTitle() {
        return "GLB Conversions: " + this.getId();
    }

    protected void computePreviews(DocumentModel doc, Blob blob) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetFileName", blob.getFilename());
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder OptimizationResult = cs.convert("glbOptimizer", (BlobHolder)new SimpleBlobHolder(blob), params);
        Blob optimizedBlob = OptimizationResult.getBlob();
        GLBRendition rendition = new GLBRendition(OPTIMIZED_RENDITION_NAME, optimizedBlob);
        GLBModelAdapter adapter = (GLBModelAdapter)doc.getAdapter(GLBModelAdapter.class);
        adapter.addRendition(rendition);
        params.clear();
        params.put("targetFileName", "thumbnail.png");
        BlobHolder thumbnailResult = cs.convert("glb2png", (BlobHolder)new SimpleBlobHolder(optimizedBlob), params);
        adapter.setThumbnail(thumbnailResult.getBlob());
    }

    protected void fireGLBConversionDoneEvent() {
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(GLB_CONVERSION_DONE_EVENT);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }
}

