/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.glb.previewer;

import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.runtime.api.Framework;

public class GLBPreviewer
implements MimeTypePreviewer {
    public List<Blob> getPreview(Blob blob, DocumentModel dm) throws PreviewException {
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        String blobUrl = downloadService.getFullDownloadUrl(dm, "file:content", blob, "/nuxeo/");
        String thumbnailUrl = downloadService.getFullDownloadUrl(dm, "thumb:thumbnail", blob, "/nuxeo/");
        String head = "<script type=\"module\" src=\"https://ajax.googleapis.com/ajax/libs/model-viewer/3.0.1/model-viewer.min.js\"></script>\n<style>\nhtml,body {\n    height: 100%;\n    width: 100%;\n    margin: 0px;\n}\n\nmodel-viewer {\n    height: 100%;\n    width: 100%;\n}\n</style>\n";
        String body = String.format("<model-viewer alt=\"%s\" src=\"%s\" poster=\"%s\"\n   environment-image=\"neutral\" shadow-intensity=\"0\" shadow-softness=\"0\" exposure=\"0.92\" camera-controls>\n</model-viewer>\n", dm.getTitle(), blobUrl, thumbnailUrl);
        String html = String.format("<!doctype html>\n<html>\n    <head>%s</head>\n    <body>%s</body>\n</html>\n", head, body);
        Blob mainBlob = Blobs.createBlob((String)html, (String)"text/html", (String)"UTF-8", (String)"index.html");
        return List.of(mainBlob);
    }
}

