/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.glb.adapter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.labs.glb.adapter.GLBRendition;

public class GLBModelAdapter {
    public static final String GLB_RENDITIONS_PROP = "glb:renditions";
    public static final String GLB_THUMBNAIL_PROP = "glb:thumbnail";
    protected final DocumentModel doc;

    public GLBModelAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    public List<GLBRendition> getRenditions() {
        List<Map<String, Serializable>> renditions = this.getStoredRenditions();
        return renditions.stream().map(GLBRendition::new).collect(Collectors.toList());
    }

    public GLBRendition getRendition(String name) {
        List<Map<String, Serializable>> renditions = this.getStoredRenditions();
        Optional<GLBRendition> result = renditions.stream().map(GLBRendition::new).filter(entry -> entry.name != null && entry.name.equals(name)).findFirst();
        return result.orElse(null);
    }

    public void addRendition(GLBRendition rendition) {
        List<Map<String, Serializable>> renditions = this.getStoredRenditions();
        renditions.add(rendition.toMap());
        this.setStoredRenditions(renditions);
    }

    public void clearRenditions() {
        this.doc.setPropertyValue(GLB_RENDITIONS_PROP, null);
        this.doc.setPropertyValue(GLB_THUMBNAIL_PROP, null);
    }

    public Blob getThumbnail() {
        return (Blob)this.doc.getPropertyValue(GLB_THUMBNAIL_PROP);
    }

    public void setThumbnail(Blob blob) {
        this.doc.setPropertyValue(GLB_THUMBNAIL_PROP, (Serializable)blob);
    }

    protected List<Map<String, Serializable>> getStoredRenditions() {
        return (List)((Object)this.doc.getPropertyValue(GLB_RENDITIONS_PROP));
    }

    protected void setStoredRenditions(List<Map<String, Serializable>> values) {
        this.doc.setPropertyValue(GLB_RENDITIONS_PROP, (Serializable)((Object)values));
    }
}

