/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.glb.listener;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.labs.glb.adapter.GLBModelAdapter;
import org.nuxeo.labs.glb.worker.GLBConversionWork;
import org.nuxeo.runtime.api.Framework;

public class GLBChangedListener
implements EventListener {
    private static final Logger log = LogManager.getLogger(GLBChangedListener.class);
    public static final String DISABLE_GLB_CONVERSIONS_GENERATION_LISTENER = "disableGLBConversionsGenerationListener";

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (Boolean.TRUE.equals(ctx.getProperty(DISABLE_GLB_CONVERSIONS_GENERATION_LISTENER))) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.trace("GLB conversions are disabled for document {}", supplierArray);
            return;
        }
        String eventName = event.getName();
        if (this.shouldProcess(doc, eventName)) {
            if ("beforeDocumentModification".equals(eventName)) {
                this.resetProperties(doc);
            }
            if (doc.getPropertyValue("file:content") != null) {
                this.scheduleAsyncProcessing(doc);
            }
        }
    }

    protected boolean shouldProcess(DocumentModel doc, String eventName) {
        return doc.hasFacet("GLB") && !doc.isProxy() && ("documentCreated".equals(eventName) || doc.getProperty("file:content").isDirty());
    }

    protected void resetProperties(DocumentModel doc) {
        log.debug("Resetting GLB info of document {}", (Object)doc);
        GLBModelAdapter adapter = (GLBModelAdapter)doc.getAdapter(GLBModelAdapter.class);
        adapter.clear();
    }

    protected void scheduleAsyncProcessing(DocumentModel doc) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        GLBConversionWork work = new GLBConversionWork(doc.getRepositoryName(), doc.getId());
        log.debug("Scheduling work: glb conversion of document {}.", (Object)doc);
        workManager.schedule((Work)work, true);
    }
}

