/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.glb.adapter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.labs.glb.adapter.GLBRenderView;
import org.nuxeo.labs.glb.adapter.GLBRendition;

public class GLBModelAdapter {
    public static final String GLB_RENDITIONS_PROP = "glb:renditions";
    public static final String GLB_RENDER_VIEWS_PROP = "picture:views";
    public static final String GLB_THUMBNAIL_PROP = "glb:thumbnail";
    protected final DocumentModel doc;

    public GLBModelAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    public void clear() {
        this.doc.setPropertyValue(GLB_RENDITIONS_PROP, null);
        this.doc.setPropertyValue(GLB_RENDER_VIEWS_PROP, null);
        this.doc.setPropertyValue(GLB_THUMBNAIL_PROP, null);
    }

    public List<GLBRendition> getRenditions() {
        List<Map<String, Serializable>> renditions = this.getStoredRenditions();
        return renditions.stream().map(GLBRendition::new).collect(Collectors.toList());
    }

    public GLBRendition getRendition(String name) {
        List<Map<String, Serializable>> renditions = this.getStoredRenditions();
        Optional<GLBRendition> result = renditions.stream().map(GLBRendition::new).filter(entry -> entry.name != null && entry.name.equals(name)).findFirst();
        return result.orElse(null);
    }

    public void addRendition(GLBRendition rendition) {
        List<GLBRendition> renditions = this.getRenditions();
        renditions = renditions.stream().filter(item -> !rendition.getName().equals(item.getName())).collect(Collectors.toList());
        renditions.add(rendition);
        this.saveRenditions(renditions);
    }

    public void removeRendition(String name) {
        List<GLBRendition> renditions = this.getRenditions();
        List<GLBRendition> filteredRenditions = renditions.stream().filter(rendition -> !name.equals(rendition.getName())).collect(Collectors.toList());
        if (renditions.size() != filteredRenditions.size()) {
            this.saveRenditions(filteredRenditions);
        }
    }

    public Blob getThumbnail() {
        return (Blob)this.doc.getPropertyValue(GLB_THUMBNAIL_PROP);
    }

    public void setThumbnail(Blob blob) {
        this.doc.setPropertyValue(GLB_THUMBNAIL_PROP, (Serializable)blob);
    }

    public List<GLBRenderView> getRenderViews() {
        List<Map<String, Serializable>> renders = this.getStoredRenderViews();
        return renders.stream().map(GLBRenderView::new).collect(Collectors.toList());
    }

    public GLBRenderView getRenderView(String name) {
        List<Map<String, Serializable>> renders = this.getStoredRenderViews();
        Optional<GLBRenderView> result = renders.stream().map(GLBRenderView::new).filter(entry -> entry.name != null && entry.name.equals(name)).findFirst();
        return result.orElse(null);
    }

    public void addRenderView(GLBRenderView renderView) {
        List<GLBRenderView> renderViews = this.getRenderViews();
        renderViews = renderViews.stream().filter(item -> !renderView.getName().equals(item.getName())).collect(Collectors.toList());
        renderViews.add(renderView);
        this.saveRenderViews(renderViews);
    }

    public void removeRenderView(String name) {
        List<GLBRenderView> renderViews = this.getRenderViews();
        List<GLBRenderView> filteredRenditions = renderViews.stream().filter(rendition -> !name.equals(rendition.getName())).collect(Collectors.toList());
        if (renderViews.size() != filteredRenditions.size()) {
            this.saveRenderViews(filteredRenditions);
        }
    }

    protected List<Map<String, Serializable>> getStoredRenditions() {
        return (List)((Object)this.doc.getPropertyValue(GLB_RENDITIONS_PROP));
    }

    public void saveRenditions(List<GLBRendition> renditions) {
        List renditionsToStore = renditions.stream().map(GLBRendition::toMap).collect(Collectors.toList());
        this.doc.setPropertyValue(GLB_RENDITIONS_PROP, (Serializable)((Object)renditionsToStore));
    }

    protected List<Map<String, Serializable>> getStoredRenderViews() {
        return (List)((Object)this.doc.getPropertyValue(GLB_RENDER_VIEWS_PROP));
    }

    public void saveRenderViews(List<GLBRenderView> renderViews) {
        List rendersToStore = renderViews.stream().map(GLBRenderView::toMap).collect(Collectors.toList());
        this.doc.setPropertyValue(GLB_RENDER_VIEWS_PROP, (Serializable)((Object)rendersToStore));
    }
}

