/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.glb.bulk;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.labs.glb.adapter.GLBModelAdapter;
import org.nuxeo.labs.glb.worker.GLBConversionWork;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class RecomputeGlbPreviewAction
implements StreamProcessorTopology {
    private static final Logger log = LogManager.getLogger(RecomputeGlbPreviewAction.class);
    public static final String ACTION_NAME = "recomputeGlbPreview";
    public static final String ACTION_FULL_NAME = "bulk/recomputeGlbPreview";
    public static final String PARAM_XPATH = "xpath";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(RecomputeGlbPreviewComputation::new, Arrays.asList("i1:bulk/recomputeGlbPreview", "o1:bulk/status")).build();
    }

    public static class RecomputeGlbPreviewComputation
    extends AbstractBulkComputation {
        protected String xpath;

        public RecomputeGlbPreviewComputation() {
            super(RecomputeGlbPreviewAction.ACTION_FULL_NAME);
        }

        public void startBucket(String bucketKey) {
            BulkCommand command = this.getCurrentCommand();
            this.xpath = (String)command.getParam(RecomputeGlbPreviewAction.PARAM_XPATH);
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            log.debug("Compute action: {} for doc ids: {}", (Object)RecomputeGlbPreviewAction.ACTION_NAME, ids);
            WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
            DocumentModelList documents = this.loadDocuments(session, ids);
            for (DocumentModel doc : documents) {
                GLBModelAdapter adapter;
                Blob blob = (Blob)doc.getPropertyValue(this.xpath);
                if (blob == null || (adapter = (GLBModelAdapter)doc.getAdapter(GLBModelAdapter.class)) == null) continue;
                adapter.clear();
                GLBConversionWork work = new GLBConversionWork(doc.getRepositoryName(), doc.getId());
                log.debug("Scheduling work: glb conversion of document {}.", (Object)doc);
                workManager.schedule((Work)work, true);
            }
        }
    }
}

