/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.glb.worker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.labs.glb.adapter.GLBModelAdapter;
import org.nuxeo.labs.glb.adapter.GLBRenderView;
import org.nuxeo.labs.glb.adapter.GLBRendition;
import org.nuxeo.runtime.api.Framework;

public class GLBConversionWork
extends AbstractWork {
    public static final String GLB_CONVERSION_DONE_EVENT = "GLBConversionDone";
    private static final Logger log = LogManager.getLogger(GLBConversionWork.class);
    public static final String OPTIMIZED_RENDITION_NAME = "optimized";
    public static final String CATEGORY = "glbConversion";
    public static final String BASELINE_ENVIRONMENT = "environment-image=neutral&shadow-intensity=0&shadow-softness=0&exposure=0.92&min-camera-orbit=-Infinity 0deg auto&max-camera-orbit=Infinity 180deg auto";

    protected static String computeIdPrefix(String repositoryName, String docId) {
        return repositoryName + ":" + docId + ":glbconversion:";
    }

    public GLBConversionWork(String repositoryName, String docId) {
        super(GLBConversionWork.computeIdPrefix(repositoryName, docId));
        this.setDocument(repositoryName, docId);
    }

    public String getCategory() {
        return CATEGORY;
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.openSystemSession();
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        Blob glb = blobHolder.getBlob();
        this.setStatus("Updating previews");
        this.computePreviews(doc, glb);
        this.doSaveAndCommit(doc, false);
        this.setStatus("Done");
        this.fireGLBConversionDoneEvent();
    }

    public int getRetryCount() {
        return 2;
    }

    public String getTitle() {
        return "GLB Conversions: " + this.getId();
    }

    protected void computePreviews(DocumentModel doc, Blob blob) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetFileName", blob.getFilename());
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder OptimizationResult = cs.convert("glbOptimizer", (BlobHolder)new SimpleBlobHolder(blob), params);
        Blob optimizedBlob = OptimizationResult.getBlob();
        GLBRendition rendition = new GLBRendition(OPTIMIZED_RENDITION_NAME, optimizedBlob);
        GLBModelAdapter adapter = (GLBModelAdapter)doc.getAdapter(GLBModelAdapter.class);
        adapter.addRendition(rendition);
        this.doSaveAndCommit(doc, true);
        Blob thumbnailBlob = this.doScreenshot(optimizedBlob, "480", "480", BASELINE_ENVIRONMENT, "thumbnail.png");
        adapter.setThumbnail(thumbnailBlob);
        this.doSaveAndCommit(doc, true);
        ArrayList<GLBRenderView> views = new ArrayList<GLBRenderView>();
        String[] viewNames = new String[]{"front", "back", "top", "bottom", "right", "left", "isometric"};
        String[] viewCoordinates = new String[]{"0deg 90deg 100%", "180deg 90deg 100%", "0deg 0deg 100%", "0deg 180deg 100%", "-90deg 90deg 100%", "90deg 90deg 100%", "45deg 45deg 100%"};
        for (int i = 0; i < viewNames.length; ++i) {
            String environment = String.format("%s&camera-orbit=%s", BASELINE_ENVIRONMENT, viewCoordinates[i]);
            Blob viewBlob = this.doScreenshot(optimizedBlob, "1080", "1080", environment, String.format("%s.png", viewNames[i]));
            GLBRenderView view = new GLBRenderView(viewNames[i], viewBlob);
            views.add(view);
        }
        adapter.saveRenderViews(views);
    }

    protected void fireGLBConversionDoneEvent() {
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(GLB_CONVERSION_DONE_EVENT);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }

    protected Blob doScreenshot(Blob glbBlob, String width, String height, String environment, String outFilename) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetFileName", outFilename);
        params.put("height", height);
        params.put("width", width);
        params.put("environment", environment);
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder result = cs.convert("glb2png", (BlobHolder)new SimpleBlobHolder(glbBlob), params);
        return result.getBlob();
    }

    protected void doSaveAndCommit(DocumentModel doc, boolean doCommit) {
        if (doc.isVersion()) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        doc.putContextData("disableGLBConversionsGenerationListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
        doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        doc.putContextData("DisableAutomaticVersioning", (Serializable)Boolean.TRUE);
        this.session.saveDocument(doc);
        if (doCommit) {
            this.commitOrRollbackTransaction();
            this.startTransaction();
        }
    }
}

