/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.hootsuite;

import java.io.IOException;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Hootsuite.GetInfoToAttachAsset", category="Hootsuite", label="Get Info To Attach Asset to a Post", description="Returns the parameters needed by hootsuite to attach the input asset to a social media post")
public class GetInfoToAttachAsset {
    public static final String ID = "Hootsuite.GetInfoToAttachAsset";
    @Param(name="rendition", required=false)
    protected String rendition;
    @Param(name="userID", required=true)
    protected String userID;
    @Param(name="directUrl", required=false)
    protected String url;
    @Context
    protected CoreSession session;
    @Context
    protected BlobManager blobManager;
    @Context
    protected MimetypeRegistry mimetypeRegistry;

    @OperationMethod
    public Blob run(DocumentModel doc) throws JSONException, IOException, NoSuchAlgorithmException {
        Blob blob = null;
        JSONObject hootsuiteParams = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)this.url)) {
            hootsuiteParams.put("url", (Object)this.url);
            hootsuiteParams.put("name", (Object)doc.getPropertyValue("dc:title"));
            hootsuiteParams.put("extension", (Object)"jpg");
            this.setToken(hootsuiteParams);
            StringBlob result = new StringBlob(hootsuiteParams.toString());
            result.setMimeType("application/json");
            return result;
        }
        if (doc.hasFacet("Picture")) {
            PictureResourceAdapter picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
            blob = picture.getPictureFromTitle(this.rendition != null ? this.rendition : "FullHD");
        } else if (doc.hasFacet("Video")) {
            VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
            blob = videoDocument.getTranscodedVideo(this.rendition != null ? this.rendition : "MP4 1080p").getBlob();
        } else {
            hootsuiteParams.put("error", (Object)"Input document is not an asset");
        }
        if (blob instanceof ManagedBlob) {
            URI url;
            BlobProvider blobProvider = this.blobManager.getBlobProvider(blob);
            if (blob.getFilename() == null) {
                blob.setFilename(doc.getName());
            }
            if ((url = blobProvider.getURI((ManagedBlob)blob, BlobManager.UsageHint.DOWNLOAD, null)) != null) {
                hootsuiteParams.put("url", (Object)url.toString());
                hootsuiteParams.put("name", (Object)blob.getFilename());
                hootsuiteParams.put("extension", this.mimetypeRegistry.getExtensionsFromMimetypeName(blob.getMimeType()).get(0));
                this.setToken(hootsuiteParams);
            } else {
                hootsuiteParams.put("error", (Object)"Cannot get a direct download URL for input document");
            }
        } else {
            hootsuiteParams.put("error", (Object)"Cannot get a direct download URL for input document");
        }
        StringBlob result = new StringBlob(hootsuiteParams.toString());
        result.setMimeType("application/json");
        return result;
    }

    protected void setToken(JSONObject object) throws NoSuchAlgorithmException, JSONException {
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        long ts = System.currentTimeMillis() / 1000L;
        object.put("timestamp", ts);
        String secret = Framework.getProperty((String)"hootsuite.secret");
        String message = this.userID + ts + object.getString("url") + secret;
        byte[] digest = md.digest(message.getBytes());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            sb.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
        }
        String token = sb.toString();
        System.out.println("Token Hex format : " + token);
        object.put("token", (Object)token);
    }
}

