/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.html.utils.operations;

import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.html.utils.HTMLParser;
import org.nuxeo.html.utils.LinkInfo;

@Operation(id="HTML.GetLinks", category="Services", label="HTML: Get Links", description="Returns a JSON string of an array of objects with tag, attribute, text and link fields (returns href and src). If input is a Document, optional xpath is the field holding the blob. The operaiton handles Note documents (whatever value in xpath).")
public class HTMLGetLinksOp {
    public static final String ID = "HTML.GetLinks";
    @Param(name="xpath", required=false)
    String xpath;

    protected JSONArray buildJsonString(ArrayList<LinkInfo> links) throws JSONException {
        JSONArray array = new JSONArray();
        for (LinkInfo li : links) {
            JSONObject object = new JSONObject();
            object.put("tag", (Object)li.getTag());
            object.put("attribute", (Object)li.getAttribute());
            object.put("text", (Object)li.getText());
            object.put("link", (Object)li.getLink());
            array.put((Object)object);
        }
        return array;
    }

    @OperationMethod
    public String run(Blob inBlob) throws IOException, JSONException {
        JSONArray array = new JSONArray();
        if (inBlob != null) {
            HTMLParser hp = new HTMLParser(inBlob);
            ArrayList<LinkInfo> links = hp.getLinks();
            array = this.buildJsonString(links);
        }
        return array.toString();
    }

    @OperationMethod
    public String run(DocumentModel inDoc) throws IOException, JSONException {
        JSONArray array = new JSONArray();
        if (inDoc != null) {
            HTMLParser hp = new HTMLParser(inDoc, this.xpath);
            ArrayList<LinkInfo> links = hp.getLinks();
            array = this.buildJsonString(links);
        }
        return array.toString();
    }

    @OperationMethod
    public String run(String inHTML) throws IOException, JSONException {
        JSONArray array = new JSONArray();
        if (inHTML != null) {
            HTMLParser hp = new HTMLParser(inHTML);
            ArrayList<LinkInfo> links = hp.getLinks();
            array = this.buildJsonString(links);
        }
        return array.toString();
    }
}

