/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.html.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderAdapterService;
import org.nuxeo.html.utils.LinkInfo;
import org.nuxeo.runtime.api.Framework;

public class HTMLParser {
    public static final String[] HANDLED_LINKS_ATTRIBUTES = new String[]{"href", "src"};
    Source source;
    protected ArrayList<LinkInfo> links;
    protected ArrayList<String> imgSrc;

    public HTMLParser(Blob inBlob) throws IOException {
        this.source = new Source(inBlob.getStream());
    }

    public HTMLParser(String inHTML) throws IOException {
        this.source = new Source((CharSequence)inHTML);
    }

    public HTMLParser(DocumentModel inDoc) throws IOException {
        this(inDoc, null);
    }

    public HTMLParser(DocumentModel inDoc, String inXPath) throws IOException {
        Blob blob = null;
        if (StringUtils.isBlank((CharSequence)inXPath)) {
            if (inDoc.hasSchema("note")) {
                BlobHolderAdapterService bhas = (BlobHolderAdapterService)Framework.getService(BlobHolderAdapterService.class);
                BlobHolder bh = bhas.getBlobHolderAdapter(inDoc);
                blob = bh.getBlob();
            } else {
                blob = (Blob)inDoc.getPropertyValue("file:content");
            }
        } else {
            blob = (Blob)inDoc.getPropertyValue(inXPath);
        }
        this.source = new Source(blob.getStream());
    }

    public ArrayList<LinkInfo> getLinks() {
        if (this.links == null) {
            this.links = new ArrayList();
            for (String attr : HANDLED_LINKS_ATTRIBUTES) {
                List linkElements = this.source.getAllElements(attr, null);
                for (Element linkElement : linkElements) {
                    String link = linkElement.getAttributeValue(attr);
                    String text = linkElement.getContent().getTextExtractor().toString();
                    this.links.add(new LinkInfo(linkElement.getName(), attr, text, link));
                }
            }
        }
        return this.links;
    }

    public List<String> getImgSrc() {
        if (this.imgSrc == null) {
            this.imgSrc = new ArrayList();
            List linkElements = this.source.getAllElements("img");
            for (Element linkElement : linkElements) {
                String src = linkElement.getAttributeValue("src");
                if (!StringUtils.isNotBlank((CharSequence)src)) continue;
                this.imgSrc.add(src);
            }
        }
        return this.imgSrc;
    }

    public String getPlainText() {
        return this.getPlainText("\n", false, false, false);
    }

    public String getPlainText(String lineSeparator, boolean includeHyperlinkURLs, boolean includeAlternateText, boolean convertNonBreakingSpaces) {
        if (StringUtils.isBlank((CharSequence)lineSeparator)) {
            lineSeparator = "\n";
        }
        this.source.fullSequentialParse();
        Renderer renderer = this.source.getRenderer();
        renderer.setIncludeHyperlinkURLs(includeHyperlinkURLs);
        renderer.setIncludeAlternateText(includeAlternateText);
        renderer.setConvertNonBreakingSpaces(convertNonBreakingSpaces);
        renderer.setDecorateFontStyles(false);
        renderer.setMaxLineLength(Integer.MAX_VALUE);
        renderer.setNewLine(lineSeparator);
        return renderer.toString();
    }

    public String getTitle() {
        String title = null;
        this.source.fullSequentialParse();
        Element titleElement = this.source.getFirstElement("title");
        if (titleElement != null) {
            title = CharacterReference.decodeCollapseWhiteSpace((CharSequence)titleElement.getContent());
        }
        return title == null ? "" : title;
    }

    public String getMetaValue(String key) {
        String value = null;
        this.source.fullSequentialParse();
        int max = this.source.length();
        int pos = 0;
        while (pos < max) {
            StartTag startTag = this.source.getNextStartTag(pos, "name", key, false);
            if (startTag == null) {
                return "";
            }
            if (startTag.getName() == "meta") {
                value = startTag.getAttributeValue("content");
                break;
            }
            pos = startTag.getEnd();
        }
        return value == null ? "" : value;
    }
}

