/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.html.utils.operations;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.html.utils.HTMLParser;

@Operation(id="HTML.GetInfo", category="Services", label="HTML: Get Info", description="Returns a JSON string of an object whose properties are title and every meta required (comma-separated list). For example, {title: \"The title\", keywords: \"kw1, kw2\"}. If input is a Document, optional xpath is the field holding the blob. The operation handles Note documents (whatever value in xpath).")
public class HTMLGetInfoOp {
    public static final String ID = "HTML.GetInfo";
    protected HTMLParser htmlParser;
    @Param(name="metaList", required=false)
    String metaList;
    @Param(name="xpath", required=false)
    String xpath;

    protected JSONObject buildInfo() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("title", (Object)this.htmlParser.getTitle());
        if (StringUtils.isNotBlank((CharSequence)this.metaList)) {
            String[] metas;
            for (String oneMeta : metas = this.metaList.split(",")) {
                oneMeta = oneMeta.trim();
                obj.put(oneMeta, (Object)this.htmlParser.getMetaValue(oneMeta));
            }
        }
        return obj;
    }

    @OperationMethod
    public String run(Blob inBlob) throws IOException, JSONException {
        JSONObject obj = new JSONObject();
        if (inBlob != null) {
            this.htmlParser = new HTMLParser(inBlob);
            obj = this.buildInfo();
        }
        return obj.toString();
    }

    @OperationMethod
    public String run(DocumentModel inDoc) throws IOException, JSONException {
        JSONObject obj = new JSONObject();
        if (inDoc != null) {
            this.htmlParser = new HTMLParser(inDoc, this.xpath);
            obj = this.buildInfo();
        }
        return obj.toString();
    }

    @OperationMethod
    public String run(String inStr) throws IOException, JSONException {
        JSONObject obj = new JSONObject();
        if (inStr != null) {
            this.htmlParser = new HTMLParser(inStr);
            obj = this.buildInfo();
        }
        return obj.toString();
    }
}

