/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.html.utils.operations;

import java.io.IOException;
import org.json.JSONException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.html.utils.HTMLParser;

@Operation(id="HTML.GetPlainText", category="Conversion", label="HTML: Get Plain Text", description="Returns the plain text of the HTML. If input is a Document, optional xpath is the field holding the blob. The operaiton handles Note documents (whatever value in xpath).")
public class HTMLGetPlainTextOp {
    public static final String ID = "HTML.GetPlainText";
    @Param(name="includeHyperlinkURLs", required=false, values={"false"})
    boolean includeHyperlinkURLs = false;
    @Param(name="includeAlternateText", required=false, values={"false"})
    boolean includeAlternateText = false;
    @Param(name="convertNonBreakingSpaces", required=false, values={"false"})
    boolean convertNonBreakingSpaces = false;
    @Param(name="lineSeparator", required=false)
    String lineSeparator = null;
    @Param(name="xpath", required=false)
    String xpath;

    @OperationMethod
    public String run(Blob inBlob) throws IOException, JSONException {
        String plainText = "";
        if (inBlob != null) {
            HTMLParser hp = new HTMLParser(inBlob);
            plainText = hp.getPlainText(this.lineSeparator, this.includeHyperlinkURLs, this.includeAlternateText, this.convertNonBreakingSpaces);
        }
        return plainText;
    }

    @OperationMethod
    public String run(String inStr) throws IOException, JSONException {
        String plainText = "";
        if (inStr != null) {
            HTMLParser hp = new HTMLParser(inStr);
            plainText = hp.getPlainText(this.lineSeparator, this.includeHyperlinkURLs, this.includeAlternateText, this.convertNonBreakingSpaces);
        }
        return plainText;
    }

    @OperationMethod
    public String run(DocumentModel inDoc) throws IOException, JSONException {
        String plainText = "";
        if (inDoc != null) {
            HTMLParser hp = new HTMLParser(inDoc, this.xpath);
            plainText = hp.getPlainText(this.lineSeparator, this.includeHyperlinkURLs, this.includeAlternateText, this.convertNonBreakingSpaces);
        }
        return plainText;
    }
}

