/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.bulk.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.validation.DocumentValidationException;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.hxai.client.objects.json.IngestibleDocument;
import org.nuxeo.hxai.client.objects.json.mappers.MapperSupplier;
import org.nuxeo.hxai.client.objects.json.post.filters.FlattenNestedFilesPostFilter;
import org.nuxeo.hxai.service.HxAi;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class IngestAction
implements StreamProcessorTopology {
    public static final String ACTION_NAME = "ingest";
    public static final String ACTION_FULL_NAME = "bulk/ingest";
    public static final String AGGREGATE_DEFAULT_MAPPING = "aggregateDefaultMapping";
    public static final String AGGREGATE_DEFAULT_TRANSFORMER = "aggregateDefaultTransformer";
    public static final String DRY_RUN_MODE = "dryRun";
    public static final String INLINE_MAPPING = "inlineMapping";
    public static final String INLINE_TRANSFORMER = "inlineTransformer";
    public static final String PARAM_VERSIONING_OPTION = "VersioningOption";
    public static final String REPLACE_MAPPING = "replaceMapping";
    public static final String PERSIST_MAPPING = "persistMapping";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(IngestComputation::new, List.of("i1:bulk/ingest", "o1:bulk/status")).build();
    }

    public static class IngestComputation
    extends AbstractBulkComputation {
        private static final Logger log = LogManager.getLogger(IngestComputation.class);
        private static final Logger jsonLog = LogManager.getLogger((String)"org.nuxeo.hxai.ingest.json.payloads");
        protected static final int MAX_ALLOWED_DOCUMENTS_PER_INGESTION_REQUEST = 100;
        protected boolean disableVersioning;
        protected boolean disableAudit;
        protected String inlineMapping;
        protected boolean aggregateDefaultMapping;
        protected String inlineTransformer;
        protected boolean aggregateDefaultTransformer;
        protected boolean replaceMapping;
        protected boolean dryRun;
        protected boolean persistMapping;

        public IngestComputation() {
            super(IngestAction.ACTION_FULL_NAME);
        }

        public void startBucket(String bucketKey) {
            BulkCommand command = this.getCurrentCommand();
            Serializable auditParam = (Serializable)command.getParam("disableAuditLogger");
            this.disableAudit = auditParam != null && Boolean.parseBoolean(auditParam.toString());
            Serializable versioningParam = (Serializable)command.getParam(IngestAction.PARAM_VERSIONING_OPTION);
            this.disableVersioning = VersioningOption.NONE.toString().equals(versioningParam);
            this.inlineMapping = (String)command.getParam(IngestAction.INLINE_MAPPING);
            Boolean aggregateMappingParam = (Boolean)command.getParam(IngestAction.AGGREGATE_DEFAULT_MAPPING);
            this.aggregateDefaultMapping = aggregateMappingParam == null || aggregateMappingParam != false;
            this.inlineTransformer = (String)command.getParam(IngestAction.INLINE_TRANSFORMER);
            Boolean aggregateTransformerParam = (Boolean)command.getParam(IngestAction.AGGREGATE_DEFAULT_TRANSFORMER);
            this.aggregateDefaultTransformer = aggregateTransformerParam == null || aggregateTransformerParam != false;
            Boolean replaceParam = (Boolean)command.getParam(IngestAction.REPLACE_MAPPING);
            this.replaceMapping = replaceParam != null && replaceParam != false;
            Boolean dryRunParam = (Boolean)command.getParam(IngestAction.DRY_RUN_MODE);
            this.dryRun = dryRunParam != null && dryRunParam != false;
            Boolean persistParam = (Boolean)command.getParam(IngestAction.PERSIST_MAPPING);
            this.persistMapping = persistParam != null && persistParam != false;
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            log.debug("Preparing a set of documents to ingest.");
            long errorCount = 0L;
            HashSet<IngestibleDocument> ingestibleDocuments = new HashSet<IngestibleDocument>();
            for (DocumentModel doc : this.loadDocuments(session, ids)) {
                if (this.disableAudit) {
                    doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
                }
                if (this.disableVersioning) {
                    doc.putContextData("DisableAutomaticVersioning", (Serializable)Boolean.TRUE);
                    doc.putContextData(IngestAction.PARAM_VERSIONING_OPTION, (Serializable)VersioningOption.NONE);
                }
                boolean updated = false;
                try {
                    IngestibleDocument ingest = this.asIngestibleDocument(doc);
                    if (this.persistMapping && !this.dryRun) {
                        doc.putContextData("ingested-by-explicit-request", (Serializable)Boolean.valueOf(true));
                        ingest.updateDocumentMapping();
                        log.debug("added ingestion sync facet to doc: {}", (Object)doc);
                    }
                    ingestibleDocuments.add(ingest);
                    if (ingestibleDocuments.size() == 100) {
                        this.doIngest(ingestibleDocuments);
                        ingestibleDocuments.clear();
                    }
                    updated = true;
                }
                catch (PropertyException e) {
                    log.warn("Cannot ingest document: {}", (Object)doc, (Object)e);
                    this.delta.inError(0L, String.format("Cannot ingest document: %s, %s", doc.getId(), e.getMessage()), 0);
                }
                if (!updated) {
                    ++errorCount;
                    continue;
                }
                if (!this.persistMapping || this.dryRun) continue;
                try {
                    session.saveDocument(doc);
                }
                catch (PropertyException | DocumentValidationException e) {
                    log.warn("Cannot save document: {}", (Object)doc, (Object)e);
                    this.delta.inError(0L, String.format("Cannot save document: %s, %s", doc.getId(), e.getMessage()), 0);
                    ++errorCount;
                }
            }
            this.doIngest(ingestibleDocuments);
            this.delta.setErrorCount(errorCount);
        }

        protected IngestibleDocument asIngestibleDocument(DocumentModel doc) {
            return new IngestibleDocument(doc, this.replaceMapping, this.inlineMapping, this.aggregateDefaultMapping, this.inlineTransformer, this.aggregateDefaultTransformer);
        }

        protected void doIngest(HashSet<IngestibleDocument> ingestibleDocuments) {
            if (CollectionUtils.isEmpty(ingestibleDocuments)) {
                return;
            }
            try {
                ObjectMapper mapper = MapperSupplier.newMapper(this.dryRun);
                ArrayNode payload = new FlattenNestedFilesPostFilter().apply((ArrayNode)mapper.valueToTree(ingestibleDocuments));
                if (this.dryRun) {
                    log.debug("DRY-RUN payload: {}", (Object)payload);
                    jsonLog.info((Object)payload);
                } else {
                    ((HxAi)Framework.getService(HxAi.class)).ingest(mapper.writeValueAsString((Object)payload));
                }
            }
            catch (IOException e) {
                log.error("Failed to ingest document set", (Throwable)e);
            }
        }
    }
}

