/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.client.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.hxai.client.api.BaseApi;
import org.nuxeo.hxai.client.objects.HxITokenGrantRequest;
import org.nuxeo.hxai.client.objects.HxITokenGrantResponse;
import org.nuxeo.hxai.client.service.HxIHttpClientFactory;
import org.nuxeo.runtime.api.Framework;

public class AuthenticationApi
extends BaseApi {
    private String endpoint;
    private static final Logger log = LogManager.getLogger(AuthenticationApi.class);

    public AuthenticationApi() {
    }

    public AuthenticationApi(String baseURL) {
        super(baseURL);
    }

    public HxITokenGrantResponse authenticate(HxITokenGrantRequest request) {
        HxITokenGrantResponse tokenGrantResponse;
        block10: {
            String token = null;
            tokenGrantResponse = null;
            try (CloseableHttpClient client = HxIHttpClientFactory.getClient("default");){
                UrlEncodedFormEntity requestEntity = new UrlEncodedFormEntity(request.toFormParams(), Consts.UTF_8);
                HttpPost authRequest = new HttpPost(this.getEndpoint());
                authRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
                authRequest.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
                authRequest.setEntity((HttpEntity)requestEntity);
                CloseableHttpResponse response = client.execute((HttpUriRequest)authRequest);
                if (response.getStatusLine().getStatusCode() == 200) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    tokenGrantResponse = (HxITokenGrantResponse)objectMapper.readValue(responseBody, HxITokenGrantResponse.class);
                    token = tokenGrantResponse.getAccessToken();
                    if (!StringUtils.isEmpty((CharSequence)token)) {
                        this.putTokenInCache(request.getClientId(), token);
                    }
                    break block10;
                }
                log.error("Error occurred when trying to authenticate to HxI");
                throw new Exception("Error occurred when trying to authenticate to HxI");
            }
            catch (Exception e) {
                log.error("Exception", (Throwable)e);
            }
        }
        return tokenGrantResponse;
    }

    public String getTokenFromCache(String key) {
        CacheService cacheService = (CacheService)Framework.getService(CacheService.class);
        Cache cache = cacheService.getCache("hxai_token_cache");
        return (String)((Object)cache.get(key));
    }

    public void putTokenInCache(String key, String token) {
        CacheService cacheService = (CacheService)Framework.getService(CacheService.class);
        Cache cache = cacheService.getCache("hxai_token_cache");
        cache.put(key, (Serializable)((Object)token));
    }

    public void clearTokenInCache(String key) {
        CacheService cacheService = (CacheService)Framework.getService(CacheService.class);
        Cache cache = cacheService.getCache("hxai_token_cache");
        cache.invalidate(key);
    }

    public void clearTokenInCache() {
        CacheService cacheService = (CacheService)Framework.getService(CacheService.class);
        Cache cache = cacheService.getCache("hxai_token_cache");
        cache.invalidateAll();
    }

    protected String getEndpoint() {
        if (StringUtils.isEmpty((CharSequence)this.endpoint)) {
            this.endpoint = this.baseURL.concat("idp/connect/token");
        }
        return this.endpoint;
    }
}

