/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.client.api;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.hxai.client.api.BaseApi;
import org.nuxeo.hxai.client.objects.PreSignedURL;
import org.nuxeo.hxai.client.service.HxIHttpClientFactory;

public class IngestionApi
extends BaseApi {
    private String ingestEventEndpoint;
    private String preSignedUrlsEndpoint;
    private String accessToken;
    private String environmentKey;
    private static final Logger log = LogManager.getLogger(IngestionApi.class);

    public IngestionApi(String baseURL, String accessToken, String environmentKey) {
        super(baseURL);
        this.accessToken = accessToken;
        this.environmentKey = environmentKey;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    public void setEnvironmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
    }

    public List<PreSignedURL> getPreSignedIngestionURLs(int count) throws URISyntaxException, IOException {
        ArrayList<PreSignedURL> urls;
        block9: {
            urls = new ArrayList();
            try (CloseableHttpClient client = HxIHttpClientFactory.getClient("default");){
                HttpPost request = new HttpPost(this.getPreSignedUrlsEndpoint());
                URI uri = new URIBuilder(request.getURI()).addParameter("count", String.valueOf(count)).build();
                request.setURI(uri);
                request.addHeader("Authorization", "Bearer " + this.accessToken);
                request.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
                request.addHeader("hxp-environment", this.environmentKey);
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() == 200) {
                    String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    ObjectMapper mapper = new ObjectMapper();
                    urls = (List)mapper.readValue(responseBody, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, PreSignedURL.class));
                    break block9;
                }
                log.error("Exception occurred while fetching preSignedURLs");
                throw new NuxeoException("Exception occurred while fetching preSignedURLs. Status Code: {}.", response.getStatusLine().getStatusCode());
            }
            catch (Exception ex) {
                log.error("Exception occurred while fetching preSignedURLs", (Throwable)ex);
                throw ex;
            }
        }
        return urls;
    }

    public void uploadFile(String url, File file, String mimeType) throws IOException {
        try (CloseableHttpClient client = HxIHttpClientFactory.getClient("uploadFile");){
            HttpPut request = new HttpPut(url);
            request.setHeader("Content-Type", mimeType.endsWith("pdf") ? "application/pdf" : mimeType);
            FileEntity fileEntity = new FileEntity(file, mimeType.endsWith("pdf") ? ContentType.create((String)"application/pdf") : ContentType.getByMimeType((String)mimeType));
            request.setEntity((HttpEntity)fileEntity);
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                log.error("Error when trying to upload File {}. HttpStatus: {}", (Object)file.getName(), (Object)response.getStatusLine().getStatusCode());
            }
        }
        catch (Exception ex) {
            log.error("Exception occurred during uploading file {} to pre-signed url: {}", (Object)file.getName(), (Object)ex);
            throw ex;
        }
    }

    public void ingest(String payload) throws IOException {
        try (CloseableHttpClient client = HxIHttpClientFactory.getClient("default");){
            HttpPost request = new HttpPost(this.getIngestEventEndpoint());
            request.addHeader("Authorization", "Bearer " + this.accessToken);
            request.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            request.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
            request.addHeader("hxp-environment", this.environmentKey);
            StringEntity entity = new StringEntity(payload);
            request.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            if (202 == status) {
                log.debug("Successfully ingested document set with payload: {}", (Object)payload);
            } else {
                log.error("Failed with status code: {} to ingest document set with payload: {}", (Object)status, (Object)payload);
            }
        }
    }

    private String getIngestEventEndpoint() {
        if (StringUtils.isEmpty((CharSequence)this.ingestEventEndpoint)) {
            this.ingestEventEndpoint = this.baseURL.concat("ingestion-events");
        }
        return this.ingestEventEndpoint;
    }

    private String getPreSignedUrlsEndpoint() {
        if (StringUtils.isEmpty((CharSequence)this.preSignedUrlsEndpoint)) {
            this.preSignedUrlsEndpoint = this.baseURL.concat("presigned-urls");
        }
        return this.preSignedUrlsEndpoint;
    }
}

