/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.client.objects.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.hxai.service.HxAi;
import org.nuxeo.runtime.api.Framework;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class IngestibleBlob
implements Serializable {
    protected String id;
    protected Blob blob;
    protected String contentType;
    protected Map<String, Serializable> contentMetadata;

    public IngestibleBlob(Blob blob, boolean dryRun) {
        this.blob = blob;
        this.contentType = blob.getMimeType();
        this.contentMetadata = new HashMap<String, Serializable>();
        this.contentMetadata.put("size", Long.valueOf(blob.getFile().length()));
        this.contentMetadata.put("name", (Serializable)((Object)blob.getFilename()));
        this.contentMetadata.put("content-type", (Serializable)((Object)blob.getMimeType()));
        this.id = dryRun ? "DRY-RUN" : ((HxAi)Framework.getService(HxAi.class)).uploadFile(blob);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="content-type")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonProperty(value="content-metadata")
    public Map<String, Serializable> getContentMetadata() {
        return this.contentMetadata;
    }

    public void setContentMetadata(Map<String, Serializable> contentMetadata) {
        this.contentMetadata = contentMetadata;
    }
}

