/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.client.objects.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.hxai.client.api.IngestEventType;
import org.nuxeo.hxai.client.objects.json.IngestibleProperty;
import org.nuxeo.hxai.client.objects.json.PropertyMappingContext;
import org.nuxeo.hxai.client.objects.json.mappers.IngestiblePropertyMapper;
import org.nuxeo.hxai.exceptions.CheckedPropertyException;
import org.nuxeo.hxai.service.IngestMappingService;
import org.nuxeo.hxai.service.IngestTransformer;
import org.nuxeo.hxai.service.SimpleIngestMapping;
import org.nuxeo.hxai.service.SimpleIngestTransformer;
import org.nuxeo.runtime.api.Framework;

public class IngestibleDocument {
    private static final Logger log = LogManager.getLogger(IngestibleDocument.class);
    @JsonIgnore
    protected String inlineMapping;
    @JsonIgnore
    protected boolean aggregateDefaultMapping;
    @JsonIgnore
    protected String inlineTransformer;
    @JsonIgnore
    protected boolean aggregateDefaultTransformer;
    @JsonIgnore
    protected List<IngestTransformer> cachedTransformers;
    @JsonIgnore
    protected DocumentModel doc;
    protected String objectId;
    protected IngestEventType eventType;
    protected String sourceId;
    protected Long sourceTimestamp = Instant.now().toEpochMilli();
    protected Map<String, IngestibleProperty> properties = new HashMap<String, IngestibleProperty>();

    public IngestibleDocument() {
    }

    public IngestibleDocument(DocumentModel doc, boolean replaceMapping, String inlineMapping, boolean aggregateDefaultMapping, String inlineTransformer, boolean aggregateDefaultTransformer) {
        this();
        this.doc = doc;
        this.objectId = doc.getId();
        this.sourceId = Framework.getProperty((String)"nuxeo.hxai.sourceid", null);
        this.eventType = this.computeLabel();
        this.inlineMapping = this.computeInlineParam(inlineMapping, replaceMapping, "hxai:inlineMapping");
        this.inlineTransformer = this.computeInlineParam(inlineTransformer, replaceMapping, "hxai:inlineTransformer");
        this.aggregateDefaultMapping = this.computeAggregationParam(aggregateDefaultMapping, "hxai:aggregateDefaultMapping");
        this.aggregateDefaultTransformer = this.computeAggregationParam(aggregateDefaultTransformer, "hxai:aggregateDefaultTransformer");
        this.mapMetadataProperties();
    }

    protected String computeInlineParam(String inlineParam, boolean replaceMapping, String propPath) {
        if (replaceMapping) {
            return inlineParam;
        }
        String storedInlineMapping = this.doc.hasFacet("HxInsightAlwaysSync") ? (String)((Object)this.doc.getPropertyValue(propPath)) : null;
        return Stream.of(storedInlineMapping, inlineParam).filter(Objects::nonNull).collect(Collectors.joining(","));
    }

    protected boolean computeAggregationParam(boolean aggregateParam, String propPath) {
        if (!aggregateParam) {
            return aggregateParam;
        }
        Serializable storedAggregateDefaultMapping = this.doc.hasFacet("HxInsightAlwaysSync") ? this.doc.getPropertyValue(propPath) : null;
        return storedAggregateDefaultMapping == null || (Boolean)storedAggregateDefaultMapping != false;
    }

    protected IngestEventType computeLabel() {
        return IngestEventType.CREATE_OR_UPDATE;
    }

    public Serializable getPropertyValue(String xPath) throws CheckedPropertyException {
        try {
            return this.doc.getPropertyValue(xPath);
        }
        catch (PropertyException e) {
            throw new CheckedPropertyException("No property: " + xPath + " in doc: " + String.valueOf(this.doc), e);
        }
    }

    protected void mapMetadataProperties() {
        HashSet<String> metadataProperties = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)this.inlineMapping)) {
            metadataProperties.addAll(new SimpleIngestMapping(this.inlineMapping).getProperties());
        }
        if (this.aggregateDefaultMapping) {
            metadataProperties.addAll(((IngestMappingService)Framework.getService(IngestMappingService.class)).getMappingForDoctypeOrDefault(this.doc.getType()));
        }
        HashMap<String, IngestibleProperty> tempProps = new HashMap<String, IngestibleProperty>();
        this.computeIngestibleProperties(tempProps, metadataProperties);
        this.transformIngestibleProperties(tempProps);
    }

    protected void computeIngestibleProperties(Map<String, IngestibleProperty> tempProps, Set<String> metadataProperties) {
        for (String p : metadataProperties) {
            Serializable v;
            IngestiblePropertyMapper ingestiblePropertyMapper = ((IngestMappingService)Framework.getService(IngestMappingService.class)).newPropertyMapper(p);
            if (ingestiblePropertyMapper != null) {
                ingestiblePropertyMapper.accept(new PropertyMappingContext(this, tempProps, p));
                continue;
            }
            try {
                v = this.getPropertyValue(p);
            }
            catch (CheckedPropertyException e) {
                log.trace(e.getMessage());
                continue;
            }
            if (v == null) continue;
            IngestibleProperty ordinary = new IngestibleProperty(p, v);
            this.addPropertyEntry(tempProps, ordinary.getKey(), ordinary);
        }
    }

    private void transformIngestibleProperties(Map<String, IngestibleProperty> tempProps) {
        for (Map.Entry<String, IngestibleProperty> e : tempProps.entrySet()) {
            IngestibleProperty property = e.getValue();
            List<IngestTransformer> list = this.cachedTransformers = this.cachedTransformers != null ? this.cachedTransformers : this.computeTransformers();
            if (!this.cachedTransformers.isEmpty()) {
                for (IngestTransformer transformer : this.cachedTransformers) {
                    transformer.chainTransformations(property);
                }
            }
            this.addPropertyEntry(this.properties, property.getKey(), property);
        }
    }

    protected List<IngestTransformer> computeTransformers() {
        IngestTransformer defaultTransformer;
        ArrayList<IngestTransformer> transformerList = new ArrayList<IngestTransformer>(2);
        if (this.aggregateDefaultTransformer && (defaultTransformer = ((IngestMappingService)Framework.getService(IngestMappingService.class)).getTransformer(this.doc.getType())) != null) {
            transformerList.add(defaultTransformer);
        }
        if (StringUtils.isNotBlank((CharSequence)this.inlineTransformer)) {
            transformerList.add(new SimpleIngestTransformer(this.inlineTransformer));
        }
        return transformerList;
    }

    public void updateDocumentMapping() {
        this.doc.addFacet("HxInsightAlwaysSync");
        this.doc.setPropertyValue("hxai:inlineMapping", (Serializable)((Object)this.inlineMapping));
        this.doc.setPropertyValue("hxai:aggregateDefaultMapping", (Serializable)Boolean.valueOf(this.aggregateDefaultMapping));
        this.doc.setPropertyValue("hxai:inlineTransformer", (Serializable)((Object)this.inlineTransformer));
        this.doc.setPropertyValue("hxai:aggregateDefaultTransformer", (Serializable)Boolean.valueOf(this.aggregateDefaultTransformer));
    }

    public String getInlineMapping() {
        return this.inlineMapping;
    }

    public boolean isAggregateDefaultMapping() {
        return this.aggregateDefaultMapping;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getInlineTransformer() {
        return this.inlineTransformer;
    }

    public boolean isAggregateDefaultTransformer() {
        return this.aggregateDefaultTransformer;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public IngestEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(IngestEventType eventType) {
        this.eventType = eventType;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Map<String, IngestibleProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, IngestibleProperty> properties) {
        this.properties = properties;
    }

    protected void addPropertyEntry(Map<String, IngestibleProperty> props, String key, IngestibleProperty p) {
        if (props.put(key, p) != null) {
            throw new NuxeoException("Ordinary value: '" + String.valueOf(p) + "' overriding a special property mapping: '" + String.valueOf(props.get(key)) + "'");
        }
    }

    public Long getSourceTimestamp() {
        return this.sourceTimestamp;
    }

    public void setSourceTimestamp(Long sourceTimestamp) {
        this.sourceTimestamp = sourceTimestamp;
    }
}

