/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.client.objects.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.hxai.client.api.IngestPropertyType;

public class IngestibleProperty
implements Serializable {
    @JsonIgnore
    protected Serializable value;
    @JsonIgnore
    protected IngestPropertyType type;
    @JsonIgnore
    protected String key;

    public IngestibleProperty(String key, Serializable value) {
        this.value = value;
        this.key = key;
        this.type = value instanceof Blob ? IngestPropertyType.FILE : IngestPropertyType.VALUE;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public IngestPropertyType getType() {
        return this.type;
    }

    public void setType(IngestPropertyType type) {
        this.type = type;
    }

    public String toString() {
        Serializable serializable = this.value;
        if (serializable instanceof String) {
            Object v = (String)((Object)serializable);
            v = "\"" + (String)v + "\"";
            return "{key: " + this.key + ", value: " + (String)v + "}";
        }
        return "{key: " + this.key + ", value: " + String.valueOf(this.value) + "}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof IngestibleProperty)) return false;
        IngestibleProperty o = (IngestibleProperty)obj;
        if (!this.key.equals(o.key)) return false;
        if (!this.value.equals(o.value)) return false;
        return true;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.key).append((Object)this.value).toHashCode();
    }
}

