/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.client.objects.json.post.filters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nuxeo.hxai.client.api.IngestPropertyType;
import org.nuxeo.hxai.client.objects.json.post.filters.IngestiblePayloadPostFilter;

public class FlattenNestedFilesPostFilter
implements IngestiblePayloadPostFilter {
    @Override
    public ArrayNode apply(ArrayNode root) {
        Iterator iroot = root.elements();
        while (iroot.hasNext()) {
            HashMap<String, ParentAndChildTuple> filesToFlatten = new HashMap<String, ParentAndChildTuple>();
            ObjectNode props = (ObjectNode)((JsonNode)iroot.next()).get("properties");
            Iterator iprops = props.fields();
            while (iprops.hasNext()) {
                Map.Entry prop = (Map.Entry)iprops.next();
                if (!((JsonNode)prop.getValue()).has(IngestPropertyType.VALUE.label)) continue;
                this.findNestedFiles("", filesToFlatten, (JsonNode)props, prop);
            }
            for (Map.Entry e : filesToFlatten.entrySet()) {
                props.set((String)e.getKey(), ((ParentAndChildTuple)e.getValue()).removeChild());
            }
        }
        return root;
    }

    protected void findNestedFiles(String currentPath, Map<String, ParentAndChildTuple> filesToFlatten, JsonNode parent, Map.Entry<String, JsonNode> entry) {
        block5: {
            JsonNode value;
            block4: {
                String key = entry.getKey();
                value = entry.getValue();
                String string = currentPath = currentPath.isBlank() ? key : currentPath + "/" + key;
                if (!(value instanceof ObjectNode)) break block4;
                ObjectNode o = (ObjectNode)value;
                if (o.size() == 1 && o.has(IngestPropertyType.FILE.label) && o.get(IngestPropertyType.FILE.label) instanceof ObjectNode) {
                    filesToFlatten.put(currentPath.replaceFirst(IngestPropertyType.VALUE.label + "/", ""), new ParentAndChildTuple(parent, entry));
                } else {
                    Iterator i = o.fields();
                    while (i.hasNext()) {
                        this.findNestedFiles(currentPath, filesToFlatten, (JsonNode)o, (Map.Entry)i.next());
                    }
                }
                break block5;
            }
            if (!(value instanceof ArrayNode)) break block5;
            ArrayNode a = (ArrayNode)value;
            int count = 0;
            Iterator i = a.elements();
            while (i.hasNext()) {
                this.findNestedFiles(currentPath, filesToFlatten, (JsonNode)a, Map.entry("" + count++, (JsonNode)i.next()));
            }
        }
    }

    protected static class ParentAndChildTuple {
        protected JsonNode parent;
        protected Map.Entry<String, JsonNode> child;

        public ParentAndChildTuple(JsonNode parent, Map.Entry<String, JsonNode> child) {
            this.parent = parent;
            this.child = child;
        }

        public JsonNode removeChild() {
            JsonNode jsonNode = this.parent;
            if (jsonNode instanceof ObjectNode) {
                ObjectNode po = (ObjectNode)jsonNode;
                po.remove(this.child.getKey());
            } else {
                ((ArrayNode)this.parent).remove(Integer.parseInt(this.child.getKey()));
            }
            return this.child.getValue();
        }
    }
}

