/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.client.service;

import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.nuxeo.runtime.api.Framework;

public class HxIHttpClientFactory {
    public static final String DEFAULT_READ_TIMEOUT = "30";
    public static final String DEFAULT_CONNECT_TIMEOUT = "10";
    public static final int SECOND_TO_MILLISECONDS = 1000;
    public static final String PROPERTY_CONNECT_TIMEOUT_FILE_UPLOAD = "nuxeo.hxai.ingest.file.upload.connect.timeout";
    public static final String PROPERTY_READ_TIMEOUT_FILE_UPLOAD = "nuxeo.hxai.ingest.file.upload.read.timeout";

    public static CloseableHttpClient getClient(String clientFor) {
        return HttpClients.custom().setDefaultRequestConfig(HxIHttpClientFactory.requestConfig(clientFor)).build();
    }

    protected static RequestConfig requestConfig(String clientFor) {
        String readTimeOut = "";
        String connectTimeOut = "";
        switch (clientFor.toLowerCase()) {
            case "uploadFile": {
                readTimeOut = Framework.getProperty((String)PROPERTY_READ_TIMEOUT_FILE_UPLOAD, (String)DEFAULT_READ_TIMEOUT);
                connectTimeOut = Framework.getProperty((String)PROPERTY_CONNECT_TIMEOUT_FILE_UPLOAD, (String)DEFAULT_CONNECT_TIMEOUT);
                break;
            }
            default: {
                readTimeOut = DEFAULT_READ_TIMEOUT;
                connectTimeOut = DEFAULT_CONNECT_TIMEOUT;
            }
        }
        RequestConfig.Builder config = RequestConfig.custom().setConnectTimeout(Integer.parseInt(connectTimeOut) * 1000).setSocketTimeout(Integer.parseInt(readTimeOut) * 1000);
        return config.build();
    }
}

