/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.hxai.client.api.AuthenticationApi;
import org.nuxeo.hxai.client.api.IngestEventType;
import org.nuxeo.hxai.client.api.IngestionApi;
import org.nuxeo.hxai.client.objects.HxITokenGrantRequest;
import org.nuxeo.hxai.client.objects.HxITokenGrantResponse;
import org.nuxeo.hxai.client.objects.PreSignedURL;
import org.nuxeo.hxai.client.objects.json.IngestibleDocument;
import org.nuxeo.hxai.service.HxAi;
import org.nuxeo.runtime.api.Framework;

public class HxAiImpl
implements HxAi {
    @Override
    public String getAccessToken() {
        AuthenticationApi api = new AuthenticationApi();
        String clientId = Framework.getProperty((String)"hxai.api.client.id");
        String token = api.getTokenFromCache(clientId);
        if (token != null) {
            return token;
        }
        try {
            api.setBaseURL(Framework.getProperty((String)"hxai.api.auth.baseurl"));
            HxITokenGrantRequest tokenGrantRequest = new HxITokenGrantRequest("urn:hyland:params:oauth:grant-type:api-credentials", clientId, Framework.getProperty((String)"hxai.api.client.secret"), "hxp.integrations");
            HxITokenGrantResponse tokenGrantResponse = api.authenticate(tokenGrantRequest);
            token = tokenGrantResponse.getAccessToken();
        }
        catch (Exception e) {
            throw new NuxeoException((Throwable)e);
        }
        return token;
    }

    @Override
    public String uploadFile(Blob blob) {
        String string;
        block8: {
            IngestionApi api = this.getIngestionApi();
            List<PreSignedURL> preSignedUrls = api.getPreSignedIngestionURLs(1);
            String url = preSignedUrls.get(0).getUrl();
            String id = preSignedUrls.get(0).getId();
            CloseableFile cfile = blob.getCloseableFile();
            try {
                api.uploadFile(url, cfile.getFile(), blob.getMimeType());
                string = id;
                if (cfile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cfile != null) {
                        try {
                            cfile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new NuxeoException((Throwable)ex);
                }
            }
            cfile.close();
        }
        return string;
    }

    @Override
    public void ingestEvent(IngestibleDocument event) {
        IngestionApi ingestionApi = this.getIngestionApi();
        try {
            ingestionApi.ingest(new ObjectMapper().writeValueAsString(List.of(event)));
        }
        catch (Exception ex) {
            throw new NuxeoException((Throwable)ex);
        }
    }

    @Override
    public void ingest(String payload) throws IOException {
        this.getIngestionApi().ingest(payload);
    }

    @Override
    public void doDeleteIngest(String docId) {
        IngestibleDocument eventRequest = new IngestibleDocument();
        eventRequest.setObjectId(docId);
        eventRequest.setEventType(IngestEventType.DELETE);
        String sourceId = Framework.getProperty((String)"nuxeo.hxai.sourceid", null);
        if (!StringUtils.isEmpty((CharSequence)sourceId)) {
            eventRequest.setSourceId(sourceId);
        }
        HxAi hxAi = (HxAi)Framework.getService(HxAi.class);
        hxAi.ingestEvent(eventRequest);
    }

    protected IngestionApi getIngestionApi() {
        String token = this.getAccessToken();
        return new IngestionApi(Framework.getProperty((String)"hxai.api.ingest.baseurl"), token, Framework.getProperty((String)"hxai.api.ingest.env.key"));
    }
}

