/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.hxai.client.objects.json.mappers.IngestiblePropertyMapper;
import org.nuxeo.hxai.service.IngestMapping;
import org.nuxeo.hxai.service.IngestMappingDescriptor;
import org.nuxeo.hxai.service.IngestMappingService;
import org.nuxeo.hxai.service.IngestTransformer;
import org.nuxeo.hxai.service.IngestTransformerDescriptor;
import org.nuxeo.hxai.service.IngestiblePropertyMappersDescriptor;
import org.nuxeo.hxai.service.SimpleIngestMapping;
import org.nuxeo.hxai.service.SimpleIngestTransformer;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class IngestMappingServiceImpl
extends DefaultComponent
implements IngestMappingService {
    private static final Logger log = LogManager.getLogger(IngestMappingServiceImpl.class);
    protected final Map<String, IngestMapping> mappings = new HashMap<String, IngestMapping>();
    protected final Map<String, Constructor<IngestiblePropertyMapper>> propertyMappers = new HashMap<String, Constructor<IngestiblePropertyMapper>>();
    protected final Map<String, SimpleIngestTransformer> transformers = new HashMap<String, SimpleIngestTransformer>();

    public void start(ComponentContext context) {
        super.start(context);
        ArrayList dependents = new ArrayList();
        this.getDescriptors("ingestMappings").forEach(d -> this.processMappingDescriptor((IngestMappingDescriptor)d, dependents));
        this.getDescriptors("ingestTransformers").forEach(d -> this.transformers.put(d.getId(), new SimpleIngestTransformer((IngestTransformerDescriptor)d)));
        this.getDescriptors("ingestPropertyMappers").forEach(this::processPropertyMappersDescriptor);
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.mappings.clear();
        this.propertyMappers.clear();
        this.transformers.clear();
    }

    protected void processPropertyMappersDescriptor(IngestiblePropertyMappersDescriptor d) {
        for (Map.Entry<String, Class<? extends IngestiblePropertyMapper>> e : d.getMappings().entrySet()) {
            try {
                this.propertyMappers.put(e.getKey(), e.getValue().getDeclaredConstructor(new Class[0]));
            }
            catch (NoSuchMethodException ex) {
                throw new NuxeoException("Could not process IngestiblePropertyMapperDescriptor: " + d.getId());
            }
        }
    }

    protected void processMappingDescriptor(IngestMappingDescriptor d, List<IngestMappingDescriptor> dependents) {
        if (dependents.contains(d)) {
            throw new IllegalArgumentException("Detected cycle in IngestMapping: " + dependents.stream().map(IngestMappingDescriptor::getId).collect(Collectors.joining("->")) + "->" + d.getId());
        }
        if (this.mappings.containsKey(d.getId())) {
            return;
        }
        log.debug("processing mapping descriptor: {}", (Object)d.getId());
        dependents.add(d);
        Set<IngestMappingDescriptor> dependencies = Arrays.stream(d.getProperties().split(",")).filter(s -> s.startsWith("@") || s.startsWith("!@")).map(s -> s.replaceAll("^(!@|@)", "")).map(s -> (IngestMappingDescriptor)this.getDescriptor("ingestMappings", (String)s)).collect(Collectors.toSet());
        if (dependencies.isEmpty()) {
            if (this.mappings.put(d.getId(), new SimpleIngestMapping(d)) == null) {
                log.debug("IngestMapping: '{}' was processed successfully.", (Object)d.getId());
            }
        } else {
            if (log.isDebugEnabled()) {
                String dependenciesString = dependencies.stream().map(IngestMappingDescriptor::getId).collect(Collectors.joining("->"));
                log.debug("IngestMapping: {} directly depends on: {}", (Object)d.getId(), (Object)dependenciesString);
            }
            dependencies.forEach(md -> {
                if (!this.mappings.containsKey(md.getId())) {
                    this.processMappingDescriptor((IngestMappingDescriptor)md, (List<IngestMappingDescriptor>)new ArrayList<IngestMappingDescriptor>(dependents));
                }
            });
            this.mappings.put(d.getId(), new SimpleIngestMapping(d));
            log.debug("IngestMapping: '{}' was processed successfully.", (Object)d.getId());
        }
        dependencies.forEach(md -> {
            if (!this.mappings.containsKey(md.getId())) {
                this.processMappingDescriptor((IngestMappingDescriptor)md, (List<IngestMappingDescriptor>)new ArrayList<IngestMappingDescriptor>(dependents));
            }
        });
        dependents.clear();
    }

    @Override
    public Set<String> getMapping(String mappingId) {
        return this.mappings.get(mappingId).getProperties();
    }

    @Override
    public Set<String> getMappingForDoctypeOrDefault(String mappingId) {
        return this.mappings.getOrDefault(mappingId, this.mappings.get("default")).getProperties();
    }

    @Override
    public IngestTransformer getTransformer(String doctype) {
        return this.transformers.get(doctype);
    }

    @Override
    public IngestiblePropertyMapper newPropertyMapper(String property) {
        try {
            Constructor<IngestiblePropertyMapper> constructor = this.propertyMappers.get(property);
            return constructor != null ? constructor.newInstance(new Object[0]) : null;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new NuxeoException("Could not process IngestiblePropertyMapperDescriptor for property: '" + property + "'");
        }
    }
}

