/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.service;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.hxai.service.IngestMapping;
import org.nuxeo.hxai.service.IngestMappingDescriptor;
import org.nuxeo.hxai.service.IngestMappingService;
import org.nuxeo.runtime.api.Framework;

public class SimpleIngestMapping
implements IngestMapping {
    private static final Logger log = LogManager.getLogger(SimpleIngestMapping.class);
    protected final Set<String> properties = new HashSet<String>();

    public SimpleIngestMapping(IngestMappingDescriptor descriptor) {
        this(descriptor.getProperties());
    }

    public SimpleIngestMapping(String mappingString) {
        String[] mapping;
        for (String m : mapping = mappingString.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)m)) continue;
            this.processMapping(m);
        }
    }

    @Override
    public Set<String> getProperties() {
        return Set.copyOf(this.properties);
    }

    protected void processMapping(String mapping) {
        String effectiveMapping = mapping.startsWith("!") ? mapping.substring(1) : mapping;
        Set<String> mappingSet = SimpleIngestMapping.expandMapping(effectiveMapping);
        if (effectiveMapping.length() < mapping.length()) {
            log.trace("Removing mapping: '{}'", (Object)effectiveMapping);
            this.properties.removeAll(mappingSet);
        } else {
            log.trace("Adding mapping: '{}'", (Object)effectiveMapping);
            this.properties.addAll(mappingSet);
        }
    }

    protected static MappingType getMappingType(String mapping) {
        if (((SchemaManager)Framework.getService(SchemaManager.class)).getSchema(mapping) != null) {
            log.trace("The '{}' mapping was identified as a schema.", (Object)mapping);
            return MappingType.SCHEMA;
        }
        if (mapping.startsWith("@")) {
            log.trace("The '{}' mapping was identified as reference to another mapping.", (Object)mapping);
            return MappingType.MAPPING;
        }
        log.trace("The '{}' mapping was identified as a property.", (Object)mapping);
        return MappingType.PROPERTY;
    }

    protected static Set<String> expandMapping(String mapping) {
        switch (SimpleIngestMapping.getMappingType(mapping)) {
            case SCHEMA: {
                return ((SchemaManager)Framework.getService(SchemaManager.class)).getSchema(mapping).getFields().stream().map(f -> {
                    if (StringUtils.isNotBlank((CharSequence)f.getName().getPrefix())) {
                        return f.getName().getPrefixedName();
                    }
                    String prefixed = mapping + ":" + f.getName().getLocalName();
                    log.warn("Non-prefixed property mapping: '{}' in schema '{}' will be replaced by: '{}' to avoid possible duplicates. Please use the prefixed version next time.", (Object)mapping, (Object)mapping, (Object)prefixed);
                    return prefixed;
                }).collect(Collectors.toSet());
            }
            case MAPPING: {
                return ((IngestMappingService)Framework.getService(IngestMappingService.class)).getMapping(mapping.substring(1));
            }
            case PROPERTY: {
                return Set.of(mapping);
            }
        }
        throw new IllegalArgumentException("Could not expand IngestMapping: '" + mapping + "'.");
    }

    protected static enum MappingType {
        SCHEMA,
        PROPERTY,
        MAPPING;

    }
}

