/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.hxai.service;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.hxai.client.objects.json.IngestibleProperty;
import org.nuxeo.hxai.service.IngestTransformer;
import org.nuxeo.hxai.service.IngestTransformerDescriptor;

public class SimpleIngestTransformer
implements IngestTransformer {
    private static final Logger log = LogManager.getLogger(SimpleIngestTransformer.class);
    protected static final String INLINE_TRANSFORMER_ID = "inline";
    protected final List<Transformation> transformations = new ArrayList<Transformation>();

    public SimpleIngestTransformer(String transformations) {
        this(INLINE_TRANSFORMER_ID, transformations);
    }

    public SimpleIngestTransformer(IngestTransformerDescriptor d) {
        this(d.getId(), d.getTransformations());
    }

    public SimpleIngestTransformer(String transformerId, String transformations) {
        for (String t : transformations.split(",")) {
            if (StringUtils.isNotBlank((CharSequence)t) && StringUtils.isNotBlank((CharSequence)t.replaceAll("[=:]+", ""))) {
                this.transformations.add(new Transformation(t, transformerId, "="));
                continue;
            }
            log.debug("ignoring meaningless Transformation: '{}' in Transformer: '{}'", (Object)t, (Object)transformerId);
        }
    }

    @Override
    public IngestibleProperty chainTransformations(IngestibleProperty property) {
        for (Transformation t : this.transformations) {
            log.trace("Transformation: '{}' Transforming '{}'", (Object)t.transformationDescriptor, (Object)property);
            property = t.transform(property);
        }
        return property;
    }

    protected static class Transformation {
        protected static final String INGEST_FUNCTIONS_PACKAGE = "org.nuxeo.hxai.ingest.functions";
        protected final String transformationDescriptor;
        protected final String transformerId;
        protected final String delimiter;
        protected XPath left;
        protected XPath right;
        protected List<Function<Serializable, Serializable>> functions = new ArrayList<Function<Serializable, Serializable>>();

        protected Transformation(String transformationDescriptor, String transformerId, String delimiter) {
            this.transformationDescriptor = transformationDescriptor;
            this.transformerId = transformerId;
            this.delimiter = delimiter;
            log.debug("Instanciating Transformation: '{}#{}'.", (Object)transformerId, (Object)transformationDescriptor);
            this.parse();
        }

        protected void parse() {
            if (StringUtils.isNotBlank((CharSequence)this.transformationDescriptor)) {
                String[] functionNames;
                String[] split = this.transformationDescriptor.split("=");
                this.left = split.length > 0 && StringUtils.isNotBlank((CharSequence)split[0]) ? new XPath(split[0].trim()) : new XPath(null);
                this.right = split.length > 1 && StringUtils.isNotBlank((CharSequence)split[1]) ? new XPath(split[1].trim()) : new XPath(null);
                log.trace("Transformation: '{}#{}' left side: '{}' is of type: '{}' right side: '{}' is of type: '{}'.", (Object)this.transformerId, (Object)this.transformationDescriptor, (Object)this.left, (Object)this.left.type, (Object)this.right, (Object)this.right.type);
                for (String f : functionNames = split.length > 2 ? Arrays.copyOfRange(split, 2, split.length) : new String[]{}) {
                    this.addFunction(f.trim());
                }
            }
            this.assertTransformation();
            this.left.assertCanBeAtLeftOf(this.right);
        }

        protected void addFunction(String functionName) {
            if (StringUtils.isNotBlank((CharSequence)functionName)) {
                Object packagedFunctionName = functionName.startsWith(".") ? "org.nuxeo.hxai.ingest.functions." + functionName.substring(1) : (!functionName.contains(".") ? "org.nuxeo.hxai.ingest.functions." + functionName : functionName);
                try {
                    this.functions.add((Function)Class.forName((String)packagedFunctionName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    log.trace("Function name: {} leads to Class: {}", (Object)functionName, packagedFunctionName);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalArgumentException("Couldn't find transformation Function: " + (String)packagedFunctionName);
                }
            } else {
                log.trace("Transformation: '{}#{}' has no function", (Object)this.transformerId, (Object)this.transformationDescriptor);
            }
        }

        public IngestibleProperty transform(IngestibleProperty property) {
            XPath xKey = new XPath(property.getKey());
            if (xKey.matches(this.left)) {
                property.setKey(xKey.computeRemap(this.right));
                property = this.functions.isEmpty() ? property : this.applyFunctions(property);
            }
            return property;
        }

        protected IngestibleProperty applyFunctions(IngestibleProperty property) {
            for (Function<Serializable, Serializable> f : this.functions) {
                property.setValue(f.apply(property.getValue()));
            }
            return property;
        }

        protected void assertTransformation() {
            if (this.left.type == XPath.TypeEnum.STAR && this.right.type != XPath.TypeEnum.STAR && this.functions.isEmpty()) {
                throw new IllegalArgumentException("Malformed Transformation: '" + this.transformerId + "#" + this.transformationDescriptor + "' with a right side only.");
            }
            if (this.left.type == XPath.TypeEnum.STAR && this.right.type != XPath.TypeEnum.STAR && this.functions != null) {
                throw new IllegalArgumentException("Malformed Transformation: '" + this.transformerId + "#" + this.transformationDescriptor + "' with a missing left side.");
            }
            if (this.left.type == XPath.TypeEnum.STAR && this.right.type == XPath.TypeEnum.STAR && this.functions.isEmpty()) {
                log.trace("Empty Transformation in Transformer: '{}' will be ignored.", (Object)this.transformerId);
            } else {
                if (this.left.type != XPath.TypeEnum.STAR && this.right.type == XPath.TypeEnum.STAR && this.functions.isEmpty()) {
                    throw new IllegalArgumentException("Malformed Transformation: '" + this.transformerId + "#" + this.transformationDescriptor + "' with a left side only.");
                }
                if (this.left.type == XPath.TypeEnum.STAR && this.right.type == XPath.TypeEnum.STAR && this.functions != null) {
                    log.trace("Transformation: '{}#{}' will transform all properties without remapping.", (Object)this.transformerId, (Object)this.transformationDescriptor);
                } else if (this.left.type != XPath.TypeEnum.STAR && this.right.type == XPath.TypeEnum.STAR && this.functions != null) {
                    log.trace("Transformation: '{}#{}' will transform selected properties without remapping.", (Object)this.transformerId, (Object)this.transformationDescriptor);
                } else {
                    if (this.left.type != XPath.TypeEnum.STAR && this.right.type != XPath.TypeEnum.STAR && this.left.getPropertySubPath().isBlank() && !this.right.getPropertySubPath().isBlank()) {
                        throw new IllegalArgumentException("Malformed Transformation: '" + this.transformerId + "#" + this.transformationDescriptor + "' with a non-item left side mapped to an indexed right side.");
                    }
                    if (this.left.type != XPath.TypeEnum.STAR && this.right.type != XPath.TypeEnum.STAR && this.functions.isEmpty()) {
                        log.trace("Transformation: '{}#{}' will only do remapping.", (Object)this.transformerId, (Object)this.transformationDescriptor);
                    } else {
                        log.trace("Transformation: '{}#{}' will remap and transform selected properties.", (Object)this.transformerId, (Object)this.transformationDescriptor);
                    }
                }
            }
        }

        protected class XPath {
            protected String path;
            protected String pre;
            protected String suf;
            protected TypeEnum type;

            protected XPath(String path) {
                Object[] split;
                Object[] objectArray = split = StringUtils.isNotBlank((CharSequence)path) ? path.split(":") : null;
                if (ArrayUtils.isEmpty((Object[])split)) {
                    this.type = TypeEnum.STAR;
                } else {
                    if (split.length > 2 || path.replaceAll(":", "").length() < path.length() - 1) {
                        throw new IllegalArgumentException("'" + path + "' path in Transformation: '" + Transformation.this.transformationDescriptor + "' in Transformer: '" + Transformation.this.transformerId + "' can contain at most 1 prefix separator ':'.");
                    }
                    this.path = path;
                    this.pre = StringUtils.isNotBlank((CharSequence)split[0]) ? ((String)split[0]).trim() : null;
                    String string = this.suf = split.length > 1 && StringUtils.isNotBlank((CharSequence)split[1]) ? ((String)split[1]).trim() : null;
                    this.type = split.length > 1 && StringUtils.isNotBlank((CharSequence)split[0]) ? TypeEnum.FULL : (path.startsWith(":") ? TypeEnum.SUFFIX : (path.endsWith(":") ? TypeEnum.PREFIX : TypeEnum.SIMPLE));
                }
            }

            protected void assertCanBeAtLeftOf(XPath target) {
                if (this.type == TypeEnum.STAR || target.type == TypeEnum.STAR || this.type == TypeEnum.SIMPLE || this.type == TypeEnum.FULL) {
                    return;
                }
                if (this.type == TypeEnum.PREFIX && !target.type.equals((Object)TypeEnum.PREFIX)) {
                    throw new IllegalArgumentException(this.getExceptionMessage(target).append("is a prefix and can only be mapped to another prefix.").toString());
                }
                if (this.type == TypeEnum.SUFFIX && !target.type.equals((Object)TypeEnum.SUFFIX)) {
                    throw new IllegalArgumentException(this.getExceptionMessage(target).append("is a suffix and can only be mapped to another suffix.").toString());
                }
            }

            protected boolean matches(XPath xpath) {
                switch (xpath.type) {
                    case STAR: {
                        return true;
                    }
                    case SIMPLE: {
                        return this.type == TypeEnum.SIMPLE && (xpath.path.equals(this.path) || this.isItemOf(xpath));
                    }
                    case PREFIX: {
                        return this.type.equals((Object)TypeEnum.FULL) && xpath.pre.equals(this.pre);
                    }
                    case SUFFIX: {
                        return this.type.equals((Object)TypeEnum.FULL) && (xpath.suf.equals(this.suf) || this.isItemOf(xpath));
                    }
                    case FULL: {
                        return this.type == TypeEnum.FULL && (xpath.path.equals(this.path) || this.isItemOf(xpath));
                    }
                }
                throw new IllegalArgumentException("Couldn't resolve matching for XPath: '" + String.valueOf(xpath) + "' on key: '" + String.valueOf(this) + "'");
            }

            protected boolean isItemOf(XPath xpath) {
                int i = this.path.lastIndexOf("/");
                if (xpath.type != TypeEnum.STAR && i > -1) {
                    return this.path.substring(0, i + 1).equals(xpath.path);
                }
                return false;
            }

            protected String getPropertyBasePath() {
                int endIndex = this.path.indexOf("/");
                return endIndex < 0 ? this.path : this.path.substring(0, endIndex);
            }

            protected String getPropertySubPath() {
                int beginIndex = this.path.indexOf("/");
                return beginIndex < 0 ? "" : this.path.substring(beginIndex);
            }

            protected String computeRemap(XPath override) {
                if (override.type == TypeEnum.STAR) {
                    return this.path;
                }
                if (this.type.equals((Object)TypeEnum.SIMPLE)) {
                    switch (override.type) {
                        case SIMPLE: 
                        case FULL: {
                            return override.getPropertyBasePath() + this.getPropertySubPath();
                        }
                        case PREFIX: {
                            return override.getPropertyBasePath() + this.path;
                        }
                        case SUFFIX: {
                            return this.getPropertyBasePath() + override.getPropertyBasePath() + this.getPropertySubPath();
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported remap for XPath: '" + String.valueOf(override) + "' overriding XPath: '" + String.valueOf(this) + "'.");
                }
                if (this.type.equals((Object)TypeEnum.FULL)) {
                    switch (override.type) {
                        case SIMPLE: 
                        case FULL: {
                            return override.getPropertyBasePath() + this.getPropertySubPath();
                        }
                        case PREFIX: {
                            return override.getPropertyBasePath() + this.suf;
                        }
                        case SUFFIX: {
                            return this.pre + override.getPropertyBasePath() + this.getPropertySubPath();
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported remap for XPath: '" + String.valueOf(override) + "' overriding XPath: '" + String.valueOf(this) + "'.");
                }
                throw new UnsupportedOperationException("Unsupported remap for XPath: '" + String.valueOf(override) + "' overriding XPath: '" + String.valueOf(this) + "'.");
            }

            public String toString() {
                return this.path;
            }

            protected StringBuilder getExceptionMessage(XPath other) {
                return new StringBuilder().append("XPath: '").append(this.path).append("' cannot be the left side of: '").append(other.path).append("' in Transformation: '").append(Transformation.this.transformerId).append("#").append(Transformation.this.transformationDescriptor).append("'.").append(" '").append(this.path).append("' ");
            }

            protected static enum TypeEnum {
                STAR,
                SIMPLE,
                PREFIX,
                SUFFIX,
                FULL;

            }
        }
    }
}

