/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.listener.action;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.listener.action.AbstractMailAction;
import org.nuxeo.runtime.api.Framework;

public class CreateDocumentsAction
extends AbstractMailAction {
    private static final Log log = LogFactory.getLog(CreateDocumentsAction.class);

    @Override
    public boolean execute(ExecutionContext context) {
        CoreSession session = this.getCoreSession(context);
        if (session == null) {
            log.error((Object)"Could not open CoreSession");
            return false;
        }
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        ExecutionContext initialContext = context.getInitialContext();
        String subject = (String)context.get("subject");
        String sender = (String)context.get("sender");
        Date sendingDate = (Date)context.get("sendingDate");
        ArrayList recipients = (ArrayList)context.get("recipients");
        ArrayList ccRecipients = (ArrayList)context.get("ccRecipients");
        List attachments = (List)context.get("attachments");
        String text = (String)context.get("text");
        String messageId = (String)context.get("messageId");
        String parentPath = (String)initialContext.get("parentPath");
        DocumentModel documentModel = session.createDocumentModel("MailMessage");
        documentModel.setPropertyValue("dc:title", (Serializable)((Object)(subject + System.currentTimeMillis())));
        documentModel.setPathInfo(parentPath, pss.generatePathSegment(documentModel));
        documentModel.setPropertyValue("dc:title", (Serializable)((Object)subject));
        documentModel.setPropertyValue("mail:messageId", (Serializable)((Object)messageId));
        documentModel.setPropertyValue("mail:sender", (Serializable)((Object)sender));
        documentModel.setPropertyValue("mail:sending_date", (Serializable)sendingDate);
        documentModel.setPropertyValue("mail:recipients", (Serializable)recipients);
        documentModel.setPropertyValue("mail:cc_recipients", (Serializable)ccRecipients);
        if (attachments != null && !attachments.isEmpty()) {
            ArrayList files = new ArrayList();
            for (FileBlob currentFileBlob : attachments) {
                if (currentFileBlob == null) continue;
                HashMap<String, Object> file = new HashMap<String, Object>();
                file.put("file", currentFileBlob);
                file.put("filename", currentFileBlob.getFilename());
                files.add(file);
            }
            documentModel.setPropertyValue("files:files", files);
        }
        documentModel.setPropertyValue("mail:cc_recipients", (Serializable)ccRecipients);
        documentModel.setPropertyValue("mail:htmlText", (Serializable)((Object)text));
        if (text != null && !text.isEmpty()) {
            String simpleText;
            Blob sb = Blobs.createBlob((String)text);
            SimpleBlobHolder simpleBlobHolder = new SimpleBlobHolder(sb);
            ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("tagFilter", "body");
            BlobHolder simpleTextBH = conversionService.convert("html2text", (BlobHolder)simpleBlobHolder, parameters);
            try {
                simpleText = simpleTextBH.getBlob().getString();
            }
            catch (IOException e) {
                throw new ClientException((Throwable)e);
            }
            documentModel.setPropertyValue("mail:text", (Serializable)((Object)simpleText));
        }
        UnrestrictedCreateDocument unrestrictedCreateDocument = new UnrestrictedCreateDocument(documentModel, session);
        unrestrictedCreateDocument.runUnrestricted();
        return true;
    }

    protected class UnrestrictedCreateDocument
    extends UnrestrictedSessionRunner {
        private DocumentModel document;

        protected UnrestrictedCreateDocument(DocumentModel document, CoreSession session) {
            super(session);
            this.document = document;
        }

        public void run() throws ClientException {
            this.document = this.session.createDocument(this.document);
            this.document = this.session.saveDocument(this.document);
            this.session.save();
        }
    }
}

