/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.web.converter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

public class MailAddressConverter
implements Converter {
    private static final String EMAIL_REGEXP = "(.*)<([A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,4})>";
    private static final Pattern pattern = Pattern.compile("(.*)<([A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,4})>", 2);

    public Object getAsObject(FacesContext ctx, UIComponent uiComp, String inStr) {
        return inStr;
    }

    public String getAsString(FacesContext ctx, UIComponent uiComp, Object inObj) {
        if (null == inObj) {
            return null;
        }
        if (inObj instanceof String) {
            String inStr = (String)inObj;
            Matcher m = pattern.matcher(inStr);
            if (m.matches()) {
                String alias = m.group(1);
                String email = m.group(2);
                if (alias.trim().toLowerCase().equals("null")) {
                    alias = email;
                }
                return String.format("<a href=\"mailto:%s\">%s</a>", email, alias);
            }
            return inStr;
        }
        return inObj.toString();
    }
}

