/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.action;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.mail.action.MessageActionDescriptor;
import org.nuxeo.ecm.platform.mail.action.MessageActionPipe;

@XObject(value="pipe")
public class MessageActionPipeDescriptor {
    private static final String START_ACTION = "StartAction";
    @XNode(value="@name")
    private String name;
    @XNode(value="@override")
    private Boolean override;
    private final Map<String, MessageActionDescriptor> actionDescriptorsRegistry = new HashMap<String, MessageActionDescriptor>();
    private MessageActionPipe pipe = new MessageActionPipe();
    @XNodeList(value="action", type=MessageActionDescriptor[].class, componentType=MessageActionDescriptor.class)
    MessageActionDescriptor[] actions;

    public String getName() {
        return this.name;
    }

    public boolean getOverride() {
        if (this.override == null) {
            return false;
        }
        return this.override;
    }

    public Map<String, MessageActionDescriptor> getActions() {
        for (MessageActionDescriptor action : this.actions) {
            this.actionDescriptorsRegistry.put(action.getId(), action);
        }
        return this.actionDescriptorsRegistry;
    }

    public void merge(MessageActionPipeDescriptor descriptor) {
        for (String actionName : descriptor.getActions().keySet()) {
            this.actionDescriptorsRegistry.put(actionName, descriptor.getActions().get(actionName));
        }
        this.pipe = new MessageActionPipe();
    }

    public MessageActionPipe getPipe() {
        if (this.pipe.isEmpty()) {
            this.fillMissingActionDestination();
            MessageActionDescriptor initialAction = this.getActions().get(START_ACTION);
            this.addAction(initialAction);
        }
        return this.pipe;
    }

    private void addAction(MessageActionDescriptor msgActionDescriptor) {
        this.pipe.add(msgActionDescriptor.getAction());
        String next = msgActionDescriptor.getTo();
        MessageActionDescriptor nextAction = this.actionDescriptorsRegistry.get(next);
        if (nextAction == null) {
            return;
        }
        this.addAction(nextAction);
    }

    private void fillMissingActionDestination() {
        for (int i = 0; i < this.actions.length - 1; ++i) {
            String newDestination;
            String destination = this.actions[i].getTo();
            if (destination != null && !"".equals(destination) || (newDestination = this.actions[i + 1].getId()) == null) continue;
            this.actions[i].setTo(newDestination);
        }
    }
}

