/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessors;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.util.DeclarationFilter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBindingsProcessorFactory
implements AnnotationProcessorFactory {
    private static final Collection<String> supportedAnnotations = Collections.unmodifiableCollection(Arrays.asList("javax.ejb.Stateless", "javax.ejb.Stateful", "javax.ejb.Remote"));
    private static final Collection<String> supportedOptions = Collections.emptySet();

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        Object result = null;
        result = atds.isEmpty() ? AnnotationProcessors.NO_OP : new ServiceBindingsProcessor(env);
        return result;
    }

    private static class ServiceBindingsProcessor
    implements AnnotationProcessor {
        private final AnnotationProcessorEnvironment env;
        AnnotationTypeDeclaration statelessAnno;
        AnnotationTypeDeclaration statefulAnno;
        AnnotationTypeDeclaration remoteAnno;

        ServiceBindingsProcessor(AnnotationProcessorEnvironment env) {
            this.env = env;
            this.remoteAnno = (AnnotationTypeDeclaration)env.getTypeDeclaration("javax.ejb.Remote");
            this.statelessAnno = (AnnotationTypeDeclaration)env.getTypeDeclaration("javax.ejb.Stateless");
            this.statefulAnno = (AnnotationTypeDeclaration)env.getTypeDeclaration("javax.ejb.Stateful");
        }

        public void process() {
            try {
                Messager log = this.env.getMessager();
                PrintWriter writer = this.env.getFiler().createTextFile(Filer.Location.CLASS_TREE, "", new File("OSGI-INF/service.bindings"), "UTF-8");
                writer.println("# This is a generated file an contains service bindigns in the form: ");
                writer.println("# SERVICE_API = SERVICE_BEAN_CLASS");
                Collection declarations = this.env.getDeclarationsAnnotatedWith(this.statefulAnno);
                declarations.addAll(this.env.getDeclarationsAnnotatedWith(this.statelessAnno));
                DeclarationFilter filter = DeclarationFilter.getFilter(ClassDeclaration.class);
                declarations = filter.filter(declarations);
                for (Declaration declaration : declarations) {
                    Collection annotations = declaration.getAnnotationMirrors();
                    for (AnnotationMirror anno : annotations) {
                        if (!anno.getAnnotationType().getDeclaration().equals(this.remoteAnno)) continue;
                        Map map = anno.getElementValues();
                        ArrayList remoteItf = null;
                        for (Map.Entry entry : map.entrySet()) {
                            if (!"value".equals(((AnnotationTypeElementDeclaration)entry.getKey()).getSimpleName())) continue;
                            remoteItf = (ArrayList)((AnnotationValue)entry.getValue()).getValue();
                            break;
                        }
                        if (remoteItf != null) {
                            String value = ((ClassDeclaration)declaration).getQualifiedName();
                            for (Object itf : remoteItf) {
                                AnnotationValue av = (AnnotationValue)itf;
                                String key = ((InterfaceType)av.getValue()).getDeclaration().getQualifiedName();
                                writer.println(key + "=" + value);
                                Collection superItfs = ((InterfaceType)av.getValue()).getSuperinterfaces();
                                for (InterfaceType superItf : superItfs) {
                                    key = superItf.getDeclaration().getQualifiedName();
                                    if (key.startsWith("java")) continue;
                                    writer.println(key + "=" + value);
                                }
                            }
                            continue;
                        }
                        log.printWarning("javax.ejb.Remote annotation without parameters on class " + declaration.getSimpleName());
                    }
                }
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

