/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.adapter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;

public class MailMessageBlobHolder
extends DocumentBlobHolder {
    protected Pattern isHtmlPattern = Pattern.compile("(.*)<(html|head|body)>(.*)", 34);
    private final String filename;

    public MailMessageBlobHolder(DocumentModel doc, String xPath, String filename) {
        super(doc, xPath);
        this.filename = filename;
    }

    public Blob getBlob() {
        Blob blob;
        String htmlTextProperty = (String)((Object)this.doc.getPropertyValue(this.xPath));
        if (htmlTextProperty != null && this.filename != null && htmlTextProperty.length() != 0) {
            blob = Blobs.createBlob((String)htmlTextProperty);
            Matcher m = this.isHtmlPattern.matcher(htmlTextProperty);
            if (m.matches()) {
                blob.setMimeType("text/html");
            }
        } else {
            String txt = (String)((Object)this.doc.getPropertyValue("mail:text"));
            if (txt == null) {
                txt = "";
            }
            blob = Blobs.createBlob((String)txt);
        }
        blob.setFilename(this.filename);
        blob.setDigest("notInBinaryStore");
        return blob;
    }
}

