/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.action;

import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.action.MessageAction;
import org.nuxeo.runtime.api.Framework;

public class StoreMessageAction
implements MessageAction {
    public static final String MAIL_MESSAGE = "MailMessage";
    private static final Log log = LogFactory.getLog(StoreMessageAction.class);
    protected final String parentPath;

    public StoreMessageAction(String parentPath) {
        this.parentPath = parentPath;
    }

    @Override
    public boolean execute(ExecutionContext context) throws MessagingException {
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        Message message = context.getMessage();
        String title = message.getSubject();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing message: " + message.getSubject()));
        }
        Thread.currentThread().setContextClassLoader(Framework.class.getClassLoader());
        try (CloseableCoreSession session = CoreInstance.openCoreSessionSystem(null);){
            DocumentModel doc = session.createDocumentModel(this.getMailDocumentType());
            doc.setProperty("dublincore", "title", (Object)(title + System.currentTimeMillis()));
            doc.setPathInfo(this.parentPath, pss.generatePathSegment(doc));
            doc.setProperty("dublincore", "title", (Object)title);
            doc = session.createDocument(doc);
            Map schemas = (Map)context.get("transformed");
            for (Map.Entry entry : schemas.entrySet()) {
                doc.setProperties((String)entry.getKey(), (Map)entry.getValue());
            }
            doc = session.saveDocument(doc);
            ACL acl = (ACL)context.get("acl");
            if (acl != null) {
                ACP acp = doc.getACP();
                acp.addACL(acl);
                doc.setACP(acp, true);
            }
            session.save();
            context.put("document", doc);
        }
        return true;
    }

    protected String getMailDocumentType() {
        return MAIL_MESSAGE;
    }

    @Override
    public void reset(ExecutionContext context) {
    }
}

