/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.security;

import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;

public class MailMessageSecurityPolicy
extends AbstractSecurityPolicy {
    public Access checkPermission(Document doc, ACP mergedAcp, NuxeoPrincipal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        List<String> resolvedPermissionsList;
        Access access = Access.UNKNOWN;
        if (doc.getType().getName().equals("MailMessage") && ((resolvedPermissionsList = Arrays.asList(resolvedPermissions)).contains("WriteProperties") || resolvedPermissionsList.contains("Write"))) {
            access = Access.DENY;
        }
        return access;
    }

    public boolean isRestrictingPermission(String permission) {
        return "Write".equals(permission) || "WriteProperties".equals(permission);
    }

    public boolean isExpressibleInQuery(String repositoryName) {
        return true;
    }

    public SQLQuery.Transformer getQueryTransformer(String repositoryName) {
        return SQLQuery.Transformer.IDENTITY;
    }
}

