/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.action.MessageAction;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;

public class DocumentURLAction
implements MessageAction {
    private static final Log log = LogFactory.getLog(DocumentURLAction.class);
    protected DocumentViewCodecManager documentViewCodecManager;
    protected final String baseUrl;

    public DocumentURLAction(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public boolean execute(ExecutionContext context) {
        DocumentModel documentModel = (DocumentModel)context.get("document");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Document url computing for doc: " + documentModel));
        }
        this.documentViewCodecManager = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        DocumentViewImpl docView = new DocumentViewImpl(documentModel);
        String url = this.documentViewCodecManager.getUrlFromDocumentView((DocumentView)docView, true, this.baseUrl);
        context.put("url", url);
        return true;
    }

    @Override
    public void reset(ExecutionContext context) {
    }
}

